/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.dao.impl;

import com.gtis.emapserver.core.dao.impl.GenericIbatisDao;
import com.gtis.emapserver.dao.ServiceDao;
import com.gtis.emapserver.entity.Service;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class ServiceDaoImpl
extends GenericIbatisDao<Service, String>
implements ServiceDao {
    private static final String SERVICE_NS = "service";

    public ServiceDaoImpl() {
        this.setSqlmapNamespace(SERVICE_NS);
    }

    public List<Service> getServices(String xzdm) {
        return this.getEntities(Collections.singletonMap("condition", Collections.singletonList("service_xzdm like '".concat(xzdm).concat("%'"))));
    }

    public List<Service> getServices(String[] serviceIds) {
        String value = "service_id in (";
        for (String serviceId : serviceIds) {
            value = value + "'".concat(serviceId).concat("',");
        }
        return this.getEntities(Collections.singletonMap("condition", Collections.singletonList(value.substring(0, value.length() - 1).concat(")"))));
    }

    public List<Service> getServices(String xzdm, String[] serviceIds) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("service_xzdm like '".concat(xzdm).concat("%'"));
        String value = "service_id in (";
        for (String serviceId : serviceIds) {
            value = value + "'".concat(serviceId).concat("',");
        }
        list.add(value.substring(0, value.length() - 1).concat(")"));
        return this.getEntities(Collections.singletonMap("condition", list));
    }

    public List<Service> getServices(Map<String, ?> condition) {
        return this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getServices"), condition);
    }

    public void deleteService(Serializable primaryKey) {
        this.getSqlMapClientTemplate().delete(this.getSqlmapNamespace().concat(".deleteService"), (Object)primaryKey);
    }

    public Service getServiceByUrl(Service service) {
        return (Service)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getServiceByUrl"), (Object)service);
    }
}

