/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.dao.impl;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeShapeFilter;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.client.SeVersion;
import com.esri.sde.sdk.client.SeXmlDoc;
import com.gtis.emapserver.core.event.GISDaoException;
import com.gtis.emapserver.core.ogc.GeometryOperation;
import com.gtis.emapserver.core.support.ibatis.SDEBaseDao;
import com.gtis.emapserver.dao.SpatialDao;
import com.gtis.emapserver.utils.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDEDaoImpl
extends SDEBaseDao
implements SpatialDao {
    private static final String ARCSDE_DEFAULT_VERSION = "DEFAULT";
    @Autowired
    private GeometryOperation geometryOperation;

    public List<Map<String, Object>> intersectByPolygon(String layerName, String wktPolygon, String[] returnFields) {
        return this.intersectByPolygon(layerName, wktPolygon, returnFields, null);
    }

    public List<Map<String, Object>> intersectByPolygon(String layerName, String wktPolygon, String[] returnFields, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (null != connection) {
            try {
                returnFields = ArrayUtils.add2Arrays((String[])returnFields, (String[])new String[]{"OBJECTID", "SHAPE"});
                SeLayer layer = this.getLayer(connection, layerName);
                if (layer != null) {
                    SeShape shape = new SeShape(layer.getCoordRef());
                    shape.generateFromText(wktPolygon);
                    List fResults = this.spatialQuery(connection, shape, layerName, returnFields);
                    if (fResults == null || fResults.size() < 1) {
                        this.logger.info("\u5206\u6790\u65e0\u7ed3\u679c\uff01");
                        return null;
                    }
                    ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
                    HashMap<String, Object> result = null;
                    for (Map item : fResults) {
                        try {
                            SeShape[] shapes;
                            SeShape tShape = (SeShape)item.get("SHAPE");
                            if (tShape == null || (shapes = shape.intersect(tShape)) == null || shapes.length == 0) continue;
                            for (SeShape tmp : shapes) {
                                result = new HashMap<String, Object>();
                                result.putAll(item);
                                result.put("SHAPE", tmp.asText(Integer.MAX_VALUE));
                                result.put("SHAPE_AREA", tmp.getArea());
                                results.add(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return results;
                }
            }
            catch (SeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean insert(String layerName, Map<String, Object> columns, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            try {
                Assert.notNull((Object)layerName, (String)"\u7f16\u8f91\u56fe\u5c42\u540d\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                SeLayer layer = this.getLayer(connection, layerName);
                if (layer != null) {
                    Assert.notNull(columns, (String)"\u7f16\u8f91\u5c5e\u6027\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    if (columns.get("SHAPE") != null) {
                        SeShape shape = new SeShape(layer.getCoordRef());
                        shape.generateFromText((String)columns.get("SHAPE"));
                        columns.put("SHAPE", shape);
                    }
                    if (this.isLayerVersioned(connection, layer)) {
                        return this.spatialInsertByVersion(connection, layer.getTableName(), columns);
                    }
                    return this.spatialInsert(connection, layerName, columns);
                }
            }
            catch (SeException e) {
                throw new GISDaoException("insert", e.getSeError().getErrDesc());
            }
        }
        return false;
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            try {
                Assert.notNull((Object)layerName, (String)"\u66f4\u65b0\u56fe\u5c42\u540d\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                SeLayer layer = this.getLayer(connection, layerName);
                if (layer != null) {
                    Assert.notNull(columns, (String)"\u66f4\u65b0\u5c5e\u6027\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    this.wktShape2SeShape(columns, layer);
                }
                connection.startTransaction();
                if (this.isLayerVersioned(connection, layer)) {
                    this.updateByVersioned(connection, layerName, columns, primaryKey);
                } else {
                    this.updateByNoVersion(connection, layerName, columns, primaryKey);
                }
                connection.commitTransaction();
                return true;
            }
            catch (Exception e) {
                try {
                    connection.rollbackTransaction();
                }
                catch (SeException e1) {
                    throw new GISDaoException("update", e1.getSeError().getErrDesc());
                }
                if (e instanceof SeException) {
                    throw new GISDaoException("update", ((SeException)((Object)e)).getSeError().getErrDesc());
                }
                throw new GISDaoException("update", e.getLocalizedMessage());
            }
        }
        return false;
    }

    private boolean updateByNoVersion(SeConnection connection, String layerName, Map columns, String objectid) {
        SeUpdate update = null;
        try {
            update = new SeUpdate(connection);
            update.toTable(layerName, this.getColumnNames(columns), "OBJECTID=" + objectid);
            SeRow row = update.getRowToSet();
            this.setRowColumnsValue(row, columns);
            update.execute();
            boolean bl = true;
            return bl;
        }
        catch (SeException e) {
            throw new GISDaoException("update", e.getSeError().getErrDesc());
        }
        finally {
            try {
                update.close();
            }
            catch (SeException e) {
                throw new GISDaoException("update", e.getSeError().getErrDesc());
            }
        }
    }

    private boolean updateByVersioned(SeConnection connection, String layerName, Map columns, String objectid) throws SeException {
        SeVersion version = new SeVersion(connection, ARCSDE_DEFAULT_VERSION);
        SeState oldState = null;
        SeState newState = null;
        SeUpdate update = null;
        try {
            oldState = new SeState(connection, version.getStateId());
            if (oldState.isOpen()) {
                try {
                    oldState.close();
                }
                catch (SeException e) {
                    this.logger.error("\u5173\u95edSeState\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
                }
            }
            newState = new SeState(connection);
            newState.create(oldState.getId());
            update = new SeUpdate(connection);
            update.setState(newState.getId(), new SeObjectId(-1L), 0);
            update.toTable(layerName, this.getColumnNames(columns), "OBJECTID=" + objectid);
            SeRow row = update.getRowToSet();
            this.setRowColumnsValue(row, columns);
            update.execute();
            version.changeState(newState.getId());
            boolean bl = true;
            return bl;
        }
        catch (SeException e) {
            throw new GISDaoException("delete", e.getSeError().getErrDesc());
        }
        finally {
            if (update != null) {
                update.close();
            }
            if (newState != null && newState.isOpen()) {
                try {
                    newState.close();
                }
                catch (SeException e) {
                    this.logger.error("\u5173\u95edSeState\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
                }
            }
        }
    }

    public boolean delete(String layerName, String primaryKey, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            SeObjectId objectId = null;
            try {
                Assert.notNull((Object)primaryKey, (String)"\u5220\u9664\u64cd\u4f5cobjectid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                objectId = new SeObjectId(Long.valueOf(primaryKey).longValue());
            }
            catch (Exception e) {
                throw new GISDaoException("delete", "ObjectId\u503c\u6709\u8bef");
            }
            if (objectId != null) {
                try {
                    Assert.notNull((Object)layerName, (String)"\u5220\u9664\u64cd\u4f5c\u64cd\u4f5c\u56fe\u5c42\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    connection.startTransaction();
                    if (this.isLayerVersioned(connection, this.getLayer(connection, layerName))) {
                        this.deleteByVersioned(connection, layerName, objectId);
                    } else {
                        this.deleteByNoVersion(connection, layerName, objectId);
                    }
                    connection.commitTransaction();
                    return true;
                }
                catch (Exception e) {
                    try {
                        connection.rollbackTransaction();
                    }
                    catch (SeException e1) {
                        throw new GISDaoException("delete", e1.getSeError().getErrDesc());
                    }
                    throw new GISDaoException("delete", e.getLocalizedMessage());
                }
            }
        }
        return false;
    }

    public List query(String layerName, String where, String[] columns, boolean returnGeometry, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        ArrayList<Map> results = null;
        if (connection != null) {
            try {
                SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName, where);
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(returnGeometry ? ArrayUtils.add2Arrays((String[])columns, (String[])new String[]{"SHAPE"}) : columns);
                queryInfo.setConstruct(sqlConstruct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList<Map>();
                while (row != null) {
                    Map m = this.seRow2Map(row);
                    try {
                        if (returnGeometry) {
                            m.put("SHAPE", ((SeShape)m.get("SHAPE")).asText(Integer.MAX_VALUE));
                        }
                    }
                    catch (SeException e) {
                        this.logger.error("shape\u8f6c\u5316\u5f02\u5e38", (Object)e.getSeError().getErrDesc());
                    }
                    results.add(m);
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                throw new GISDaoException("query", e.getSeError().getErrDesc());
            }
        }
        return results;
    }

    public List query(String layerName, String wktString, String[] columns, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            try {
                List results;
                Assert.notNull((Object)layerName, (String)"\u67e5\u8be2\u56fe\u5c42\u540d\u4e0d\u53ef\u4e3a\u7a7a");
                SeLayer layer = this.getLayer(connection, layerName);
                SeShape shape = new SeShape(layer.getCoordRef());
                shape.generateFromText(wktString);
                Assert.notNull((Object)columns, (String)"\u67e5\u8be2\u5217\u4e0d\u53ef\u4e3a\u7a7a");
                if (!ArrayUtils.contains((String[])columns, (String)"SHAPE", (boolean)true)) {
                    columns = ArrayUtils.add2Arrays((String[])columns, (String[])new String[]{"SHAPE"});
                }
                if ((results = this.spatialQuery(connection, shape, layerName, columns)) != null) {
                    for (Map map : results) {
                        map.put("SHAPE", ((SeShape)map.get("SHAPE")).asText(Integer.MAX_VALUE));
                    }
                }
                return results;
            }
            catch (SeException e) {
                throw new GISDaoException("query", e.getSeError().getErrDesc());
            }
        }
        return null;
    }

    private boolean deleteByNoVersion(SeConnection connection, String layerName, SeObjectId objectId) throws SeException {
        SeDelete delete = null;
        try {
            delete = new SeDelete(connection);
            delete.byId(layerName, objectId);
        }
        catch (SeException e) {
            throw new GISDaoException("delete", e.getSeError().getErrDesc());
        }
        finally {
            delete.close();
        }
        return true;
    }

    private boolean deleteByVersioned(SeConnection connection, String layerName, SeObjectId objectId) throws SeException {
        SeVersion version = new SeVersion(connection, ARCSDE_DEFAULT_VERSION);
        SeState oldState = null;
        SeState newState = null;
        SeDelete delete = null;
        try {
            oldState = new SeState(connection, version.getStateId());
            if (oldState.isOpen()) {
                try {
                    oldState.close();
                }
                catch (SeException e) {
                    this.logger.error("\u5173\u95edSeState\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
                }
            }
            newState = new SeState(connection);
            newState.create(oldState.getId());
            delete = new SeDelete(connection);
            delete.setState(newState.getId(), new SeObjectId(-1L), 0);
            delete.byId(layerName, objectId);
            version.changeState(newState.getId());
            boolean e = true;
            return e;
        }
        catch (SeException e) {
            throw new GISDaoException("delete", e.getSeError().getErrDesc());
        }
        finally {
            if (delete != null) {
                delete.close();
            }
            if (newState != null && newState.isOpen()) {
                try {
                    newState.close();
                }
                catch (SeException e) {
                    this.logger.error("\u5173\u95edSeState\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
                }
            }
        }
    }

    public List immediateSearch(String layerName, String[] fields, String keyword) {
        SeConnection con = this.getConnection(null);
        ArrayList<String> results = null;
        if (con != null) {
            try {
                SeSqlConstruct construct = new SeSqlConstruct(layerName, this.getWhereClause(fields, keyword));
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(fields);
                queryInfo.setConstruct(construct);
                SeQuery query = new SeQuery(con);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList<String>();
                for (int i = 0; row != null && i < 20; ++i) {
                    Map map = this.seRow2Map(row);
                    for (String f : fields) {
                        if (String.valueOf(map.get(f)).indexOf(keyword) <= -1) continue;
                        results.add(String.valueOf(map.get(f)));
                        break;
                    }
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                this.logger.error("\u5373\u65f6\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            }
            catch (Exception e) {
                this.logger.error("\u5373\u65f6\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            }
        }
        return results;
    }

    private String getWhereClause(String[] fields, String keyword) {
        String or = " or ";
        StringBuilder b = new StringBuilder();
        for (String field : fields) {
            b.append(field);
            b.append(" like '%");
            b.append(keyword);
            b.append("%'");
            b.append(or);
        }
        b.delete(b.length() - or.length(), b.length());
        return b.toString();
    }

    public List fullSearch(String layerName, String[] fields, String keyword) {
        SeConnection connection = this.getConnection(null);
        ArrayList results = null;
        if (connection != null) {
            try {
                SeSqlConstruct construct = new SeSqlConstruct(layerName, this.getWhereClause(fields, keyword));
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(ArrayUtils.add2Arrays((String[])fields, (String[])new String[]{"SHAPE"}));
                queryInfo.setConstruct(construct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList();
                for (int i = 0; row != null && i < 20; ++i) {
                    Map tmp = this.seRow2Map(row);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    try {
                        for (Map.Entry e : tmp.entrySet()) {
                            Map.Entry entry = e;
                            String key = (String)entry.getKey();
                            if ("SHAPE".equals(key)) {
                                map.put("SHAPE", ((SeShape)entry.getValue()).getAllCoords());
                                continue;
                            }
                            if (String.valueOf(entry.getValue()).indexOf(keyword) > -1) {
                                map.put(key, entry.getValue());
                                map.put("key", entry.getValue());
                                continue;
                            }
                            map.put(key, entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                    }
                    results.add(map);
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                this.logger.error("\u5168\u6587\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            }
        }
        return results;
    }

    private SeShape getShapeFromWktGeometry(String wktGeometry, int wkid) throws Exception {
        SeShape shape = null;
        try {
            SeCoordinateReference cr = new SeCoordinateReference();
            cr.setCoordSysByDescription(this.geometryOperation.getWKTStringFromSrid(wkid));
            shape = new SeShape(cr);
            shape.generateFromText(wktGeometry);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Shape\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
        return shape;
    }

    private SeShape getShapeFromWktGeometry(String wktGeometry, String crDescription) throws Exception {
        SeShape shape = null;
        try {
            SeCoordinateReference cr = new SeCoordinateReference();
            cr.setCoordSysByDescription(crDescription);
            shape = new SeShape(cr);
            shape.generateFromText(wktGeometry);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Shape\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
        return shape;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean spatialInsert(SeConnection connection, String layerName, Map<String, Object> columns) {
        try {
            SeInsert insert = new SeInsert(connection);
            connection.startTransaction();
            try {
                insert.intoTable(layerName, this.getColumnNames(columns));
                SeRow row = insert.getRowToSet();
                this.setRowColumnsValue(row, columns);
                insert.execute();
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException("insert", e.getSeError().getErrDesc());
            }
            finally {
                insert.close();
            }
        }
        catch (SeException e) {
            throw new GISDaoException("insert", e.getSeError().getErrDesc());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean spatialInsertByVersion(SeConnection connection, String layerName, Map<String, Object> columns) {
        try {
            SeVersion version = new SeVersion(connection, ARCSDE_DEFAULT_VERSION);
            SeState oldState = null;
            SeState newState = null;
            SeInsert insert = new SeInsert(connection);
            try {
                oldState = new SeState(connection, version.getStateId());
                if (oldState.isOpen()) {
                    try {
                        oldState.close();
                    }
                    catch (SeException e) {
                        e.printStackTrace();
                    }
                }
                newState = new SeState(connection);
                newState.create(oldState.getId());
                try {
                    connection.startTransaction();
                    insert.setState(newState.getId(), new SeObjectId(-1L), 0);
                    insert.intoTable(layerName, this.getColumnNames(columns));
                    SeRow row = insert.getRowToSet();
                    this.setRowColumnsValue(row, columns);
                    insert.execute();
                    version.changeState(newState.getId());
                    connection.commitTransaction();
                    boolean bl = true;
                    return bl;
                }
                catch (SeException e) {
                    try {
                        connection.rollbackTransaction();
                        throw new GISDaoException("insert", e.getSeError().getErrDesc());
                    }
                    catch (SeException e2) {
                        throw new GISDaoException("insert", e2.getSeError().getErrDesc());
                    }
                }
            }
            finally {
                insert.close();
                if (newState.isOpen()) {
                    try {
                        newState.close();
                    }
                    catch (SeException e) {
                        throw new GISDaoException("insert", e.getSeError().getErrDesc());
                    }
                }
            }
        }
        catch (SeException e) {
            throw new GISDaoException("insert", e.getSeError().getErrDesc());
        }
    }

    private List<Map<String, Object>> spatialQuery(SeConnection connection, SeShape shape, String layerName, String[] columns) {
        SeShapeFilter filter = new SeShapeFilter(layerName, "SHAPE", shape, 7);
        SeFilter[] filters = new SeFilter[]{filter};
        SeQuery query = null;
        SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName);
        try {
            if (columns == null | columns.length < 1) {
                columns = this.getLayerColumns(connection, layerName);
            }
            query = new SeQuery(connection, columns, sqlConstruct);
            query.prepareQuery();
            query.setSpatialConstraints((short)2, true, filters);
            query.execute();
            SeRow row = query.fetch();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (row != null) {
                list.add(this.seRow2Map(row));
                row = query.fetch();
            }
            query.close();
            return list;
        }
        catch (SeException e) {
            this.logger.error("\u7a7a\u95f4\u67e5\u8be2\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            return null;
        }
    }

    private SeLayer getLayer(SeConnection connection, String layerName) throws SeException {
        if (connection == null || StringUtils.isBlank((String)layerName)) {
            return null;
        }
        this.logger.info("\u56fe\u5c42\u540d:" + layerName);
        SeLayer layer = new SeLayer(connection, layerName, "SHAPE");
        return layer;
    }

    private List<SeLayer> getLayers(String dbSource) throws SeException {
        SeConnection connection = this.getConnection(dbSource);
        return connection.getLayers();
    }

    private String[] getColumnNames(Map<String, ?> columns) {
        if (columns == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String key : columns.keySet()) {
            if (key == null) continue;
            names.add(key);
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getLayerColumns(SeConnection connection, String layerName) {
        String[] cols = null;
        try {
            SeTable table = new SeTable(connection, layerName);
            SeColumnDefinition[] colDefs = table.describe();
            cols = new String[colDefs.length];
            for (int i = 0; i < colDefs.length; ++i) {
                cols[i] = colDefs[i].getName();
            }
        }
        catch (SeException e) {
            this.logger.error("\u83b7\u53d6\u8868\u3010{}\u3011\u5217\u5f02\u5e38\u3010{}\u3011", (Object)layerName, (Object)e.getSeError().getErrDesc());
        }
        return cols;
    }

    private void setRowColumnsValue(SeRow row, Map<String, Object> columns) {
        try {
            for (int i = 0; i < row.getNumColumns(); ++i) {
                SeColumnDefinition colDef = row.getColumnDef(i);
                try {
                    if (columns.get(colDef.getName()) == null) continue;
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            row.setString(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 14: {
                            row.setNString(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 8: {
                            row.setShape(i, (SeShape)columns.get(colDef.getName()));
                            break;
                        }
                        case 2: {
                            if (columns.get(colDef.getName()).equals("")) {
                                row.setInteger(i, Integer.valueOf(0));
                                break;
                            }
                            row.setInteger(i, Integer.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 11: {
                            if (columns.get(colDef.getName()).equals("")) {
                                row.setLong(i, Long.valueOf(0L));
                                break;
                            }
                            row.setLong(i, Long.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 1: {
                            if (columns.get(colDef.getName()).equals("")) {
                                row.setShort(i, Short.valueOf("0"));
                                break;
                            }
                            row.setShort(i, Short.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 3: {
                            if (columns.get(colDef.getName()).equals("")) {
                                row.setFloat(i, Float.valueOf(0.0f));
                                break;
                            }
                            row.setFloat(i, Float.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 4: {
                            if (columns.get(colDef.getName()).equals("")) {
                                row.setDouble(i, Double.valueOf(0.0));
                                break;
                            }
                            row.setDouble(i, Double.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 7: {
                            Calendar calendar = Calendar.getInstance();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = null;
                            try {
                                date = sdf.parse((String)columns.get(colDef.getName()));
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            calendar.setTime(date);
                            row.setTime(i, calendar);
                            break;
                        }
                        case 12: {
                            row.setUuid(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 13: {
                            row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                            break;
                        }
                        case 15: {
                            row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                            break;
                        }
                        case 10: {
                            SeXmlDoc xml = new SeXmlDoc();
                            xml.setText((String)columns.get(colDef.getName()));
                            row.setXml(i, xml);
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    this.logger.error("\u5217\u503c\u8bbe\u7f6e\u5f02\u5e38\u3010{}\u3011", (Object)colDef.getName());
                }
            }
        }
        catch (SeException e) {
            this.logger.error("\u5217\u503c\u8bbe\u7f6e\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
        }
    }

    private Map seRow2Map(SeRow row) {
        if (row == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int colCount = row.getNumColumns();
            SeColumnDefinition colDef = null;
            for (int i = 0; i < colCount; ++i) {
                colDef = row.getColumnDef(i);
                try {
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            map.put(colDef.getName(), row.getString(i));
                            break;
                        }
                        case 14: {
                            map.put(colDef.getName(), row.getNString(i));
                            break;
                        }
                        case 2: {
                            map.put(colDef.getName(), row.getInteger(i));
                            break;
                        }
                        case 8: {
                            try {
                                map.put(colDef.getName(), row.getShape(i));
                            }
                            catch (SeException e) {}
                            break;
                        }
                        case 7: {
                            map.put(colDef.getName(), row.getTime(i));
                            break;
                        }
                        case 1: {
                            map.put(colDef.getName(), row.getShort(i));
                            break;
                        }
                        case 11: {
                            map.put(colDef.getName(), row.getLong(i));
                            break;
                        }
                        case 3: {
                            map.put(colDef.getName(), row.getFloat(i));
                            break;
                        }
                        case 4: {
                            map.put(colDef.getName(), row.getDouble(i));
                            break;
                        }
                        case 12: {
                            map.put(colDef.getName(), row.getUuid(i));
                            break;
                        }
                        case 13: {
                            map.put(colDef.getName(), row.getClob(i));
                            break;
                        }
                        case 15: {
                            map.put(colDef.getName(), row.getNClob(i));
                            break;
                        }
                        case 10: {
                            map.put(colDef.getName(), row.getXml(i) != null ? row.getXml(i).getText() : "");
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SeException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map wktShape2SeShape(Map columns, SeLayer layer) throws SeException {
        if (columns.get("SHAPE") != null) {
            SeShape shape = new SeShape(layer.getCoordRef());
            shape.generateFromText((String)columns.get("SHAPE"));
            columns.put("SHAPE", shape);
        }
        return columns;
    }

    private boolean isLayerVersioned(SeConnection connection, SeLayer layer) {
        try {
            Vector registers = connection.getRegisteredTables();
            for (Object item : registers) {
                SeRegistration registration = (SeRegistration)item;
                if (!registration.hasLayer() || !registration.isMultiVersion() || !registration.getTableName().equals(layer.getTableName())) continue;
                return true;
            }
        }
        catch (SeException e) {
            this.logger.error(e.getSeError().getErrDesc());
        }
        return false;
    }

    private boolean contains(String[] src, String des) {
        return ArrayUtils.contains((String[])src, (String)des, (boolean)false);
    }
}

