/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.core.support.ibatis;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInstance;
import com.gtis.emapserver.core.arcsde.SDEDataSource;
import com.gtis.emapserver.core.support.spring.DataBaseContextHolder;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDEBaseDao {
    protected static final String SE_OBJECTID_FIELD = "OBJECTID";
    protected static final String SE_SHAPE_FIELD = "SHAPE";
    protected static final String SE_SHAPE_AREA = "SHAPE_AREA";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="sdeDataSource")
    private SDEDataSource dataSource;

    public SDEDataSource getDataSource() {
        return this.dataSource;
    }

    protected SeConnection getConnection(String dbSource) {
        try {
            if (StringUtils.isNotBlank((String)dbSource)) {
                DataBaseContextHolder.setDataBaseType((String)dbSource);
            }
            return this.getDataSource().getSeConnection();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6SDE\u8fde\u63a5\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u3010{}\u3011", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    protected SeInstance getSeInstance(String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            try {
                SeInstance instance = new SeInstance(connection.getServer(), connection.getInstance());
                return instance;
            }
            catch (SeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

