/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.core.service.impl;

import com.gtis.emapserver.core.service.FileStoreService;
import com.gtis.emapserver.dao.FileStoreDao;
import com.gtis.emapserver.entity.FileStore;
import com.gtis.emapserver.utils.FilesUtils;
import com.gtis.generic.util.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStoreServiceImpl
implements FileStoreService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String EGOV_HOME = "${egov.conf}";
    private static final int THRESHOLD = 0xA00000;
    private static final String THUMB_SUFFIX = "_thumb";
    @Autowired
    private FileStoreDao fileStoreDao;
    private Resource baseLocation;
    private Resource location;
    private Resource tempFile;
    private long maxSize;

    public boolean save(HttpServletRequest request, String parentId) throws Exception {
        Assert.notNull((Object)parentId, (String)"\u5b58\u50a8\u6587\u4ef6\u7684\u7236ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        try {
            List fileItems = this.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) continue;
                DiskFileItem diskFileItem = (DiskFileItem)item;
                File newFile = this.getNewFile(item.getName());
                if (diskFileItem.isInMemory()) {
                    FileUtils.copyInputStreamToFile((InputStream)diskFileItem.getInputStream(), (File)newFile);
                } else {
                    File tmpFile = diskFileItem.getStoreLocation();
                    FileUtils.copyFile((File)tmpFile, (File)newFile, (boolean)true);
                }
                this.createThumb(newFile);
                this.save2DB(newFile, parentId, diskFileItem);
                this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u3010{}\u3011\u4fdd\u5b58\u6210\u529f", (Object)item.getName());
            }
            this.clearTempFiles();
        }
        catch (FileUploadException e) {
            this.logger.error("\u4e0a\u4f20\u89e3\u6790\u5f02\u5e38:[{}]", (Object)e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return false;
    }

    public boolean delete(String id) throws Exception {
        File thumbFile;
        File file = this.getFile(id);
        if (file.exists()) {
            file.delete();
        }
        if ((thumbFile = this.getThumb(id)) != null && thumbFile.exists()) {
            thumbFile.delete();
        }
        this.fileStoreDao.delete((Serializable)((Object)id));
        this.logger.debug("\u8bb0\u5f55\u3010{}\u3011\u6210\u529f\u5220\u9664", (Object)id);
        return true;
    }

    private void save2DB(File file, String parentId, DiskFileItem itemInfo) {
        try {
            String path = this.getRealPath(file.getPath());
            FileStore fs = new FileStore();
            fs.setName(itemInfo.getName());
            fs.setPath(path);
            fs.setParentId(parentId);
            fs.setCreateTime(Calendar.getInstance().getTime());
            fs.setSize(itemInfo.getSize());
            this.fileStoreDao.insert((Object)fs);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u5b58\u50a8\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    private void createThumb(File file) {
        Assert.notNull((Object)file, (String)"\u5f85\u751f\u6210\u7f29\u7565\u56fe\u6587\u4ef6\u4e0d\u5b58\u5728");
        try {
            String path = file.getPath();
            String suffix = path.substring(path.lastIndexOf("."), path.length());
            String aPath = path.replace(suffix, THUMB_SUFFIX.concat(suffix));
            File aFile = new File(aPath);
            if (FilesUtils.isImage((File)file)) {
                ImageUtils.resizeImageWithMaxWidth((String)file.getPath(), (String)aFile.getPath(), (int)100);
            }
            this.logger.debug("\u7f29\u7565\u56fe\u6210\u529f\u751f\u6210\u3010{}\u3011", (Object)file.getPath());
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7f29\u7565\u56fe\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    private List<FileItem> parseRequest(HttpServletRequest servletRequest) throws FileUploadException, IOException {
        DiskFileItemFactory fac = this.createDiskFileItemFactory(this.tempFile.getURI().getPath());
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
        upload.setSizeMax(this.maxSize);
        return upload.parseRequest(this.createRequestContext(servletRequest));
    }

    public String[] getFileIds(String parentId) throws Exception {
        Assert.notNull((Object)parentId, (String)"\u67e5\u8be2\u7236ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        List files = this.fileStoreDao.getFileByParentId(parentId);
        if (files != null && files.size() > 0) {
            String[] ids = new String[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                ids[i] = ((FileStore)files.get(i)).getId();
            }
            return ids;
        }
        return new String[0];
    }

    private DiskFileItemFactory createDiskFileItemFactory(String saveDir) {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0xA00000);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        fac.setFileCleaningTracker(FileCleanerCleanup.getFileCleaningTracker((ServletContext)ServletActionContext.getServletContext()));
        return fac;
    }

    private RequestContext createRequestContext(HttpServletRequest req) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private File getNewFile(String name) {
        File file = null;
        try {
            String path = this.location.getURI().getPath();
            file = new File(path.concat("/" + name));
            if (file.exists()) {
                file = new File(path.concat("/" + this.reNameFile(name)));
            }
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return file;
    }

    private String reNameFile(String name) {
        if (name.lastIndexOf(".") > -1) {
            int index = name.lastIndexOf(".");
            String suffix = name.substring(index, name.length());
            return name.replace(suffix, "_" + System.currentTimeMillis() + suffix);
        }
        return name + "_" + System.currentTimeMillis();
    }

    public File getFile(String id) throws Exception {
        Assert.notNull((Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        FileStore fileStore = (FileStore)this.fileStoreDao.find((Serializable)((Object)id));
        String path = this.getRealPath(fileStore.getPath());
        return new File(path);
    }

    public File getThumb(String id) throws Exception {
        Assert.notNull((Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        FileStore fileStore = (FileStore)this.fileStoreDao.find((Serializable)((Object)id));
        String path = this.getRealPath(fileStore.getPath());
        File thumbFile = new File(this.getThumbPath(path));
        if (thumbFile.exists()) {
            return thumbFile;
        }
        return null;
    }

    private void clearTempFiles() {
    }

    private String getThumbPath(String path) {
        Assert.notNull((Object)path, (String)"path\u4e0d\u53ef\u4e3a\u7a7a");
        String suffix = path.substring(path.lastIndexOf("."), path.length());
        return path.replace(suffix, THUMB_SUFFIX.concat(suffix));
    }

    private String getRealPath(String path) throws IOException {
        return path.replace(EGOV_HOME, this.baseLocation.getFile().getPath());
    }

    public void setBaseLocation(Resource baseLocation) {
        this.baseLocation = baseLocation;
    }

    public void setLocation(Resource location) {
        this.location = location;
        try {
            if (!location.exists()) {
                location.getFile().mkdirs();
            }
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efaFileStore\u76ee\u5f55\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public void setTempFile(Resource tempFile) {
        this.tempFile = tempFile;
        try {
            if (!tempFile.exists()) {
                tempFile.getFile().mkdirs();
            }
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efaFileStore\u4e34\u65f6\u76ee\u5f55\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

