<%@ page session="false" pageEncoding="UTF-8" %>
<%@ include file="common/includes.jsp" %>
<html>
<head>
    <title>任务管理</title>
    <meta name="page" content="job"/>
</head>
<body>
<table class="list-table" cellpadding="0" cellspacing="0">
    <caption>
        <a href="#" id="addJob" class="add-btn">安装任务</a>
    </caption>
    <tr>
        <th>名称</th>
        <th style="width:50px;">版本</th>
        <th style="width:250px;">调度</th>
        <th style="width:200px;">操作</th>
    </tr>
    <c:forEach items="${jobs}" var="job">
        <tr${!job.enable?' class="stop"':''}>
            <td>${job.name}</td>
            <td>${job.version} </td>
            <td>${job.crontab}</td>
            <td>
                <a href="job/edit/${job.name}" onclick="return showEdit(this)">参数设置</a>&nbsp;&nbsp;
                <a href="job/run/${job.name}" onclick="return runJob(this);">立即运行</a>&nbsp;&nbsp;
                <a href="job/status/${job.name}" onclick="return confirm('确定要启用吗?')">${job.enable?'停用':'启用'}</a>&nbsp;&nbsp;
                <a href="job/remove/${job.name}" onclick="return confirm('确定要卸载吗?')">卸载</a>
            </td>
        </tr>
    </c:forEach>
</table>
<div id="installDialog" class="ui-helper-hidden" title="安装任务">
    <h1>请选择要安装的jar包</h1>

    <form action="job/install" method="post" enctype="multipart/form-data">
        <input id="file" type="file" name="file" size="30"/>
    </form>
</div>
<div id="cfgDialog" class="ui-helper-hidden" title="参数配置"></div>
<script type="text/javascript">
    var iframe = $("#cfgDialog iframe");
    function runJob(a) {
        $.post(a.href, function (pid) {
            if (confirm('运行成功,点击确定查看运行报告')) {
                location.href = 'report/view/' + pid;
            }
        });
        return false;
    }
    function showEdit(a) {
        var dig = $("#cfgDialog").dialog({
            width:500,
            modal:true,
            buttons:{
                '关 闭':function () {
                    dig.dialog('close');
                },
                '保 存':function () {
                    $.post(a.href, $('#cfgDialog form').serialize(), function (json) {
                        if (json.ret) {
                            alert(json.msg);
                        } else {
                            dig.dialog('close');
                        }
                    });
                }
            }
        });
        $.get(a.href + '?_s' + (new Date().getTime()), function (html) {
            dig.html(html);
        });
        return false;
    }
    $(function () {
        $("#addJob").button({ icons:{primary:'ui-icon-circle-plus'} }).click(function () {
            $("#installDialog").dialog({
                width:350,
                modal:true,
                buttons:{
                    '关 闭':function () {
                        $(this).dialog('close');
                    },
                    '安 装':function () {
                        var form = $('#installDialog form')[0];
                        if (!/\.jar$/i.test(form.file.value)) {
                            alert('请选择jar包');
                        } else {
                            form.submit();
                        }
                    }
                }
            });
        });
    });
</script>
</body>
</html>
