/*
 * Decompiled with CFR 0.152.
 */
package com.gits.etl.service.impl;

import com.gits.etl.model.Job;
import com.gits.etl.model.JobFuture;
import com.gits.etl.model.JobInstance;
import com.gits.etl.model.JobListener;
import com.gits.etl.service.JobManager;
import com.gits.etl.service.JobReportManager;
import com.gits.etl.service.impl.JobManagerImpl;
import com.gits.etl.util.CfgUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManagerImpl
implements JobManager,
JobListener {
    protected final Log LOG = LogFactory.getLog(JobManagerImpl.class);
    @Autowired
    private JobReportManager jobReportManager;
    private Map<String, Job> jobs = new ConcurrentHashMap();
    private Map<String, JobFuture> scheduledjobs = new ConcurrentHashMap();
    private Map<String, JobInstance> jobInstances = new ConcurrentHashMap();
    private TaskScheduler taskScheduler;
    private BundleContext bundleContext;
    private File cfgRoot;

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setCfgRoot(Resource cfgRoot) throws IOException {
        this.cfgRoot = cfgRoot.getFile();
    }

    public Job getJob(String jobName) {
        try {
            return ((Job)this.jobs.get(jobName)).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Job saveJob(Job job) {
        if (job.getPreferences().isEmpty()) {
            this.loadJobCfg(job);
        } else {
            this.saveJobCfg(job);
        }
        Job srcJob = (Job)this.jobs.get(job.getName());
        if (srcJob != null) {
            boolean crontabChange;
            boolean bl = crontabChange = job.getCrontab() != null && !job.getCrontab().equals(srcJob.getCrontab());
            if (srcJob.isEnable() && crontabChange) {
                this.changeJobSchedule(job, false);
            }
            if (job.isEnable() && (crontabChange || !srcJob.isEnable())) {
                this.changeJobSchedule(job, true);
            }
        } else if (job.isEnable()) {
            this.changeJobSchedule(job, true);
        }
        this.jobs.put(job.getName(), job);
        return job;
    }

    private void saveJobCfg(Job job) {
        Properties props = new Properties();
        Properties defProps = this.loadDefaultCfg(job);
        for (Map.Entry entry : job.getPreferences().entrySet()) {
            String defValue = defProps.getProperty((String)entry.getKey());
            String value = (String)entry.getValue();
            if (StringUtils.isNotBlank((String)value) && !value.equals(defValue)) {
                props.put(entry.getKey(), value);
                continue;
            }
            entry.setValue(defValue);
        }
        if (job.getCrontab() != null) {
            props.put("_crontab", job.getCrontab());
        }
        props.put("_enable", String.valueOf(job.isEnable()));
        CfgUtils.save((Properties)props, (File)this.getCfgFile(job));
    }

    private File getCfgFile(Job job) {
        return new File(this.cfgRoot, job.getName() + ".cfg");
    }

    private void loadJobCfg(Job job) {
        Properties props = this.loadDefaultCfg(job);
        File cfg = this.getCfgFile(job);
        if (cfg.exists()) {
            CfgUtils.load((Properties)props, (File)this.getCfgFile(job));
        }
        Map map = job.getPreferences();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("_enable".equals(name)) {
                job.setEnable(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if ("_crontab".equals(name)) {
                job.setCrontab(value);
                continue;
            }
            map.put(name, value);
        }
    }

    private Properties loadDefaultCfg(Job job) {
        Properties props = new Properties();
        try {
            JobInstance instance = new JobInstance(job.getJobClass().newInstance());
            return CfgUtils.load((Properties)props, (InputStream)job.getJobClass().getResourceAsStream("contexts/" + instance.getContextStr() + ".properties"));
        }
        catch (Exception e) {
            this.LOG.error((Object)("Load job " + job.getName() + " props error"), (Throwable)e);
            return props;
        }
    }

    public void removeJob(String jobName) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals(jobName)) continue;
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                this.LOG.error((Object)("Remove job " + jobName + " error"), (Throwable)e);
            }
        }
    }

    public boolean installJob(String name, InputStream inputStream) {
        try {
            Bundle bundle = this.bundleContext.installBundle(name, inputStream);
            bundle.start();
            Thread.sleep(200L);
            return true;
        }
        catch (BundleException e) {
            this.LOG.error((Object)("install job " + name + " error"), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public List<Job> getJobs() {
        ArrayList<Job> list = new ArrayList<Job>(this.jobs.values());
        Collections.sort(list);
        return list;
    }

    public List<JobFuture> getJobFutures() {
        ArrayList<JobFuture> list = new ArrayList<JobFuture>(this.scheduledjobs.values());
        Collections.sort(list);
        return list;
    }

    public String runJob(String jobName, Map<String, String> params) {
        JobTask task = new JobTask(this, params);
        JobFuture future = new JobFuture(jobName, this.taskScheduler.schedule((Runnable)task, new Date(System.currentTimeMillis() + 10L)));
        task.setFutureId(future.getId());
        this.registerJobFuture(future);
        return future.getId();
    }

    public void stopJob(String futureId) {
        ScheduledFuture future = (ScheduledFuture)this.scheduledjobs.get(futureId);
        future.cancel(true);
        this.scheduledjobs.remove(futureId);
        this.jobInstances.remove(futureId);
    }

    public JobInstance getJobInstance(String futureId) {
        return (JobInstance)this.jobInstances.get(futureId);
    }

    public Map<String, JobInstance> getJobInstances() {
        return this.jobInstances;
    }

    public void setJobEnable(String jobName, boolean enable) {
        Job job = (Job)this.jobs.get(jobName);
        if (job.isEnable() != enable) {
            this.changeJobSchedule(job, enable);
            job.setEnable(enable);
            this.saveJobCfg(job);
        }
    }

    protected void changeJobSchedule(Job job, boolean enable) {
        if (enable) {
            if (job.getCrontab() != null) {
                JobTask task = new JobTask(this, null);
                JobFuture future = new JobFuture(job.getName(), this.taskScheduler.schedule((Runnable)task, (Trigger)new CronTrigger(job.getCrontab())));
                task.setFutureId(future.getId());
                this.registerJobFuture(future);
            }
        } else {
            this.stopJobByName(job.getName());
        }
    }

    protected void stopJobByName(String jobName) {
        Iterator it = this.scheduledjobs.entrySet().iterator();
        while (it.hasNext()) {
            JobFuture future = (JobFuture)it.next().getValue();
            if (!jobName.equals(future.getJobName())) continue;
            future.cancel(false);
            it.remove();
            this.jobInstances.remove(future.getId());
        }
    }

    public void init() {
        this.LOG.info((Object)"init calling, creating and opening ServiceTracker...");
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter("(objectClass=routines.system.api.TalendJob)");
        }
        catch (InvalidSyntaxException e) {
            this.LOG.error((Object)"create jobs filter error ", (Throwable)e);
        }
        new ServiceTracker(this.bundleContext, filter, (ServiceTrackerCustomizer)new Customizer(this, (JobListener)this, null)).open();
    }

    private JobFuture registerJobFuture(JobFuture jobFuture) {
        this.scheduledjobs.put(jobFuture.getId(), jobFuture);
        return jobFuture;
    }

    public void jobAdded(Object object, String name) {
        JobInstance instance = new JobInstance(object);
        Job job = new Job();
        job.setName(name);
        job.setVersion(instance.getJobVersion());
        job.setJobClass(object.getClass());
        this.saveJob(job);
    }

    public void jobRemoved(Object object, String name) {
        JobInstance instance = new JobInstance(object);
        this.jobs.remove(instance.getJobName());
        this.stopJobByName(name);
    }

    static /* synthetic */ Map access$200(JobManagerImpl x0) {
        return x0.scheduledjobs;
    }

    static /* synthetic */ Map access$300(JobManagerImpl x0) {
        return x0.jobs;
    }

    static /* synthetic */ Map access$400(JobManagerImpl x0) {
        return x0.jobInstances;
    }

    static /* synthetic */ JobReportManager access$500(JobManagerImpl x0) {
        return x0.jobReportManager;
    }

    static /* synthetic */ BundleContext access$600(JobManagerImpl x0) {
        return x0.bundleContext;
    }
}

