/*
 * Decompiled with CFR 0.152.
 */
package com.gits.etl.model;

import com.gtis.util.UUIDGenerator;
import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.DateUtils;

public class JobFuture
implements ScheduledFuture {
    private String id = UUIDGenerator.generate();
    private String jobName;
    private ScheduledFuture future;

    public JobFuture(String jobName, ScheduledFuture future) {
        this.future = future;
        this.jobName = jobName;
    }

    public String getId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public Object get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public long getDelay(TimeUnit unit) {
        return this.future.getDelay(unit);
    }

    public int compareTo(Delayed o) {
        return this.future.compareTo(o);
    }

    public Date getNextTime() {
        return DateUtils.addMilliseconds((Date)new Date(), (int)((int)this.getDelay(TimeUnit.MILLISECONDS)));
    }

    public boolean hasNextTime() {
        return this.future.getClass().getName().equals("org.springframework.scheduling.concurrent.ReschedulingRunnable");
    }
}

