package com.gits.etl.web;

import com.gits.etl.Constants;
import com.gits.etl.model.Job;
import org.apache.commons.lang.StringUtils;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TimeZone;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-29
 */
@Controller
@RequestMapping(value = "job")
public class JobController extends BaseController {

    @RequestMapping(method = RequestMethod.GET)
    public String job(Model model) {
        model.addAttribute("jobs", jobManager.getJobs());
        return "job";
    }

    @RequestMapping(value = "install")
    public String jobInstall(@RequestParam(value = "file", required = false) MultipartFile file) throws IOException {
        jobManager.installJob(file.getName(), file.getInputStream());
        return "redirect:/job";
    }

    @RequestMapping(value = "run/{name}")
    @ResponseBody
    public String jobRun(@PathVariable String name) {
        return jobManager.runJob(name, null);
    }

    @RequestMapping(value = "edit/{name}", method = RequestMethod.GET)
    public String jobEdit(Model model, @PathVariable String name) {
        model.addAttribute("job", jobManager.getJob(name));
        return "job-edit";
    }

    @RequestMapping(value = "edit/{name}", method = RequestMethod.POST)
    @ResponseBody
    public Model jobSave(Model model, @PathVariable String name, HttpServletRequest request) {
        Job job = jobManager.getJob(name);
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String) en.nextElement();
            String value = StringUtils.trim(request.getParameter(key));
            if (Constants.CRONTAB.equals(key)) {
                try {
                    if (StringUtils.isBlank(value)) {
                        job.setCrontab(null);
                    } else {
                        new CronSequenceGenerator(value, TimeZone.getDefault());
                        job.setCrontab(value);
                    }
                } catch (Exception e) {
                    return failed(model, "错误的crontab表达式");
                }
            } else {
                job.getPreferences().put(key, value);
            }
        }
        jobManager.saveJob(job);
        return success(model);
    }

    @RequestMapping(value = "status/{name}")
    public String jobStatus(@PathVariable String name) {
        jobManager.setJobEnable(name, !jobManager.getJob(name).isEnable());
        return "redirect:/job";
    }

    @RequestMapping(value = "remove/{name}")
    public String jobRemove(@PathVariable String name) {
        jobManager.removeJob(name);
        return "redirect:/job";
    }
}
