package com.gits.etl.util;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.FatalBeanException;

import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
@SuppressWarnings("unchecked")
public class DirectBeanAccessor extends DirectFieldAccessor implements BeanAccessor {

    protected final Object target;

    public DirectBeanAccessor(Object target) {
        super(target);
        this.target = target;
    }

    public <T> T getFieldValue(String propertyName) throws BeansException {
        return (T) getPropertyValue(propertyName);
    }

    public <T> T invoke(String methodName, Object... args) throws BeansException {
        Method method;
        if (args == null) {
            method = BeanUtils.findMethod(target.getClass(), methodName);
        } else {
            Class[] paramTypes = new Class[args.length];
            for (int i = 0, len = args.length; i < len; i++) {
                paramTypes[i] = args[i].getClass();
            }
            method = BeanUtils.findMethod(target.getClass(), methodName, paramTypes);
        }
        if (method == null) {
            throw new FatalBeanException("method '" + methodName + "' with args [" + Arrays.toString(args) + "] in class [" + target.getClass().getName() + "] not found");
        }
        try {
            return (T) method.invoke(target, args);
        } catch (Exception ex) {
            throw new FatalBeanException("invoke method '" + methodName + "' of bean class [" + target.getClass().getName() + "] error", ex);
        }
    }
}
