package com.gits.etl.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.*;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
public class CfgUtils {
    protected static final Log LOG = LogFactory.getLog(CfgUtils.class);

    public static Properties load(Properties props, InputStream inputStream) {
        Reader reader = null;
        try {
            reader = new InputStreamReader(inputStream, "UTF-8");
            props.load(reader);
        } catch (IOException ignored) {
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException ignored) {
                }
            }
        }
        return props;
    }

    public static void save(Properties props, OutputStream outputStream) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(outputStream, "UTF-8");
            props.store(writer, null);
        } catch (IOException ignored) {
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException ignored) {
                }
            }
        }
    }

    public static Properties load(Properties props, File file) {
        if (file.exists()) {
            try {
                load(props, new FileInputStream(file));
            } catch (FileNotFoundException e) {
                LOG.error("load props erro ,file [" + file.getAbsolutePath() + "] not found");
            }
        }
        return props;
    }

    public static Properties save(Properties props, File file) {
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            save(props, new FileOutputStream(file));
        } catch (IOException ignored) {
            LOG.error("save props to file [" + file.getAbsolutePath() + "] error");
        }
        return props;
    }

}
