package com.gits.etl.service;

import com.gits.etl.model.Job;
import com.gits.etl.model.JobFuture;
import com.gits.etl.model.JobInstance;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-23
 */
public interface JobManager {

    Job getJob(String jobName);

    Job saveJob(Job job);

    void removeJob(String jobName);

    boolean installJob(String name, InputStream inputStream);

    List<Job> getJobs();

    List<JobFuture> getJobFutures();

    String runJob(String jobName, Map<String, String> params);

    void stopJob(String futureId);

    JobInstance getJobInstance(String futureId);

    Map<String, JobInstance> getJobInstances();

    void setJobEnable(String jobName, boolean enable);
}
