package com.gits.etl.osgi;

import org.apache.karaf.main.Main;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-23
 */
public class FrameworkFactoryBean implements FactoryBean<Framework> {
    private static Logger logger = LoggerFactory.getLogger(FrameworkFactoryBean.class);

    private Main main;
    private Resource rootPath;
    private Resource dataPath;

    public void setRootPath(Resource rootPath) {
        this.rootPath = rootPath;
    }

    public void setDataPath(Resource dataPath) {
        this.dataPath = dataPath;
    }

    public Framework getObject() throws Exception {
        return main.getFramework();
    }

    public Class<?> getObjectType() {
        return Framework.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void init() throws Exception {
        String root = rootPath.getFile().getAbsolutePath();
        String data = dataPath.getFile().getAbsolutePath();
        logger.info("Start karaf instance,root [{}],data [{}]", root, data);
        System.setProperty("karaf.home", root);
        System.setProperty("karaf.base", root);
        System.setProperty("karaf.data", data);
        System.setProperty("karaf.instances", data + "/instances");
        System.setProperty("karaf.history", data + "/data/history.txt");
        System.setProperty("karaf.startLocalConsole", "false");
        System.setProperty("karaf.startRemoteShell", "true");
        System.setProperty("karaf.lock", "false");
        main = new Main(new String[0]);
        main.launch();
    }

    public void destory() throws Exception {
        logger.info("destroy karaf instance");
        main.destroy();
    }
}
