package com.gits.etl.model;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
public class Job implements Cloneable, Comparable<Job> {
    private String name;
    private String version;
    private Class jobClass;
    private String crontab;
    private boolean enable;
    private Map<String, String> preferences = new LinkedHashMap<String, String>();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Class getJobClass() {
        return jobClass;
    }

    public void setJobClass(Class jobClass) {
        this.jobClass = jobClass;
    }

    public String getCrontab() {
        return crontab;
    }

    public void setCrontab(String crontab) {
        this.crontab = crontab;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Map<String, String> getPreferences() {
        return preferences;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    @Override
    public Job clone() throws CloneNotSupportedException {
        Job job = (Job) super.clone();
        job.setPreferences(new LinkedHashMap<String, String>(getPreferences()));
        return (Job) super.clone();
    }

    public int compareTo(Job o) {
        return name.compareTo(o.getName());
    }
}
