/*
 * Decompiled with CFR 0.152.
 */
package freemarker.sweet;

import freemarker.core.Environment;
import freemarker.core.ExposeDirective;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.ParamDirective;
import freemarker.sweet.BeanUtils;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectiveHelper {
    public static final String ELEMENT_STACK = "elementStack";
    public static final String MACRO_CONTEXT_MAP = "__macro_context";

    public static void init(Configuration cfg) {
        cfg.setSharedVariable("param", (TemplateModel)new ParamDirective());
        cfg.setSharedVariable("expose", (TemplateModel)new ExposeDirective());
    }

    public static List getElementStack(Environment env) {
        return (List)BeanUtils.getValue((Object)env, ELEMENT_STACK);
    }

    public static String getRequiredParam(Map params, String key) throws TemplateException {
        Object value = params.get(key);
        if (value == null || "".equals(value.toString())) {
            throw new TemplateModelException("param " + key + " is required");
        }
        return value.toString();
    }

    public static String getParam(Map params, String key, String defaultValue) {
        Object value = params.get(key);
        return value == null || "".equals(value.toString()) ? defaultValue : value.toString();
    }

    public static LocalContext getMacroContext(Environment env) throws TemplateModelException {
        List stack = DirectiveHelper.getElementStack(env);
        for (int i = stack.size() - 1; i > -1; --i) {
            if (!(stack.get(i) instanceof Macro)) continue;
            return DirectiveHelper.getMacroContext(env, stack.get(i - 1));
        }
        return null;
    }

    public static LocalContext getMacroContext(Environment env, Object macroCall) throws TemplateModelException {
        MacroContextMap map = (MacroContextMap)env.getVariable(MACRO_CONTEXT_MAP);
        return map != null ? map.get(macroCall) : null;
    }

    public static void exposeMacroContext(Environment env, Object macroCall, LocalContext context) throws TemplateModelException {
        MacroContextMap map = (MacroContextMap)env.getGlobalVariable(MACRO_CONTEXT_MAP);
        if (map == null) {
            map = new MacroContextMap();
            env.setGlobalVariable(MACRO_CONTEXT_MAP, (TemplateModel)map);
        }
        map.put(macroCall, context);
    }

    static class MacroContextMap
    implements TemplateModel {
        private Map<Object, LocalContext> map = new HashMap<Object, LocalContext>();

        MacroContextMap() {
        }

        LocalContext get(Object key) {
            return this.map.get(key);
        }

        void put(Object key, LocalContext context) {
            this.map.put(key, context);
        }
    }
}

