/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.MimeType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Index
implements Serializable {
    private static final long serialVersionUID = -4191156991215104794L;
    public static final Pattern TRIM_TAG_PATTERN = Pattern.compile("<.*?>");
    public static final String[] DEFAULT_OWNER_IDS = new String[]{"0"};
    private String id;
    private MimeType mimeType = MimeType.TEXT;
    private String businessId;
    private String categoryId;
    private String[] ownerIds = DEFAULT_OWNER_IDS;
    private String title;
    private String body;
    private Date date;
    private boolean isPublic = true;
    private Map<String, Serializable> searchableFields = new LinkedHashMap<String, Serializable>();
    private Map<String, Serializable> fields = new HashMap<String, Serializable>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String[] getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(String[] ownerIds) {
        this.ownerIds = ownerIds;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void appendBody(String text) {
        this.appendBody(text, -1);
    }

    public void appendBody(String text, int maxLength) {
        if (StringUtils.isNotBlank((String)text)) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.body)) {
                sb.append(this.body).append(" ");
            }
            if (maxLength > 0) {
                text = StringUtils.left((String)Index.trimTag(text), (int)maxLength);
            }
            sb.append(text);
            this.body = sb.toString();
        }
    }

    public void insertBody(String text) {
        this.insertBody(text, -1);
    }

    public void insertBody(String text, int maxLength) {
        if (StringUtils.isNotBlank((String)text)) {
            if (maxLength > 0) {
                text = StringUtils.left((String)Index.trimTag(text), (int)maxLength);
            }
            StringBuilder sb = new StringBuilder(text);
            if (StringUtils.isNotEmpty((String)this.body)) {
                sb.append(" ").append(this.body);
            }
            this.body = sb.toString();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public Map<String, Serializable> getFields() {
        return this.fields;
    }

    public Map<String, Serializable> getSearchableFields() {
        return this.searchableFields;
    }

    public void addField(String name, Serializable value) {
        if (value != null) {
            this.fields.put(name, value);
        }
    }

    public void addSearchableField(String name, Serializable value) {
        if (value != null) {
            this.searchableFields.put(name, value);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "," + this.title + "," + this.businessId + "," + this.categoryId + "]";
    }

    public static String trimTag(String s) {
        if (s == null) {
            return null;
        }
        return TRIM_TAG_PATTERN.matcher(s).replaceAll("");
    }
}

