/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.MimeType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MimeTypeHelper {
    public static final Set<String> IMAGE_POSTFIX = new HashSet<String>();
    public static final Set<String> DOCUMENT_POSTFIX = new HashSet<String>();

    public static MimeType getMimeType(String fileName) {
        String ext = MimeTypeHelper.getExt(fileName);
        if (ext == null) {
            return MimeType.TEXT;
        }
        if (IMAGE_POSTFIX.contains(ext)) {
            return MimeType.IMG;
        }
        if (DOCUMENT_POSTFIX.contains(ext)) {
            return MimeType.DOC;
        }
        return MimeType.BIN;
    }

    public static String getExt(String fileName) {
        int index;
        if (fileName != null && (index = fileName.lastIndexOf(46)) > -1 && index < fileName.length() - 1) {
            return fileName.substring(index + 1).toLowerCase();
        }
        return null;
    }

    static {
        Collections.addAll(IMAGE_POSTFIX, "gif", "bmp", "jpg", "jpeg", "png");
        Collections.addAll(DOCUMENT_POSTFIX, "doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf");
    }
}

