/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    Log log = LogFactory.getLog(this.getClass());
    private ClassLoader cl;

    public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.cl = cl;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        if (osc.getName().equals("[Ljava.lang.Object;")) {
            return new Object[0].getClass();
        }
        return this.cl.loadClass(osc.getName());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfacesClass = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
        }
        return Proxy.getProxyClass(this.cl, interfacesClass);
    }
}

