/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.common;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Page<T>
implements Serializable {
    public static final int ALL = -1;
    public static final int SHOW_PAGES = 8;
    public static final int DEFAULT_SIZE = 20;
    private static final long serialVersionUID = 399508739687121397L;
    protected int totalCount = 0;
    protected List<T> items = Collections.emptyList();
    private int index = 1;
    private int size = 20;

    public Page() {
    }

    public Page(int index) {
        this.index = index;
    }

    public Page(List<T> items) {
        this.items = items;
    }

    public Page(int index, int size) {
        this(index);
        this.size = size;
    }

    @JSONField(serialize=false)
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public T getItem(int index) {
        return this.items.get(index);
    }

    @JSONField(serialize=false)
    public List<Integer> getShowPages() {
        ArrayList<Integer> pages = new ArrayList<Integer>();
        int start = this.index - 8;
        int end = this.index + 8;
        int total = this.getPageCount();
        start = start > 0 ? start : 1;
        end = end > total ? total : end;
        for (int i = start; i <= end; ++i) {
            pages.add(i);
        }
        return pages;
    }

    @JSONField(serialize=false)
    public int getPageCount() {
        int count = this.totalCount / this.size;
        return this.totalCount % this.size != 0 ? count + 1 : count;
    }

    public void setStart(int start) {
        this.index = Page.toIndex(start, this.size);
    }

    @JSONField(serialize=false)
    public boolean isEmpty() {
        return this.totalCount == 0;
    }

    public static int toIndex(int start, int size) {
        return start / size + 1;
    }

    public static int toStart(Integer index, int size) {
        if (index == null) {
            return 0;
        }
        return (index - 1) * size;
    }
}

