/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import com.gtis.util.ThreadPool;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsyncIndexManager
implements IndexManager {
    protected static final Logger LOG = LoggerFactory.getLogger(RsyncIndexManager.class);
    private IndexManager indexManager;

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void update(final Index ... indexes) {
        if (ArrayUtils.isEmpty((Object[])indexes)) {
            return;
        }
        ThreadPool.execute(new Runnable(){

            public void run() {
                try {
                    RsyncIndexManager.this.indexManager.update(indexes);
                }
                catch (Exception e) {
                    LOG.error("Error to update index [" + Arrays.toString(indexes) + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }

    public void remove(final String ... ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return;
        }
        ThreadPool.execute(new Runnable(){

            public void run() {
                try {
                    RsyncIndexManager.this.indexManager.remove(ids);
                }
                catch (Exception e) {
                    LOG.error("Error to remove index [id:" + Arrays.toString(ids) + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }

    public void reloadBusiness(final String businessId) {
        ThreadPool.execute(new Runnable(){

            public void run() {
                try {
                    RsyncIndexManager.this.indexManager.reloadBusiness(businessId);
                }
                catch (Exception e) {
                    LOG.error("Error to reload business [" + businessId + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }
}

