/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.Business;
import com.gtis.search.BusinessFactory;
import com.gtis.search.Category;
import com.gtis.search.CategoryFactory;
import com.gtis.search.DataFetcher;
import com.gtis.search.Index;
import com.gtis.search.IndexProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityIndexProvider<T>
implements IndexProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, BusinessFactory> businessFactories = new HashMap<String, BusinessFactory>();
    protected Business defaultBusiness;

    public void setBusinessFactories(List<BusinessFactory> businessFactories) {
        for (BusinessFactory bizf : businessFactories) {
            this.businessFactories.put(bizf.getId(), bizf);
            if (this.defaultBusiness != null) continue;
            this.defaultBusiness = bizf.getBusiness();
        }
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public List<Business> getBusinesses() {
        ArrayList<Business> list = new ArrayList<Business>(this.businessFactories.size());
        for (BusinessFactory biz : this.businessFactories.values()) {
            list.add(biz.getBusiness());
        }
        return list;
    }

    @Override
    public List<Index> getIndexes(String categoryId, int start, int size) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (T entity : this.getEntities(categoryId, start, size)) {
            list.add(this.toIndex(entity));
        }
        return list;
    }

    @Override
    public Index getIndex(String categoryId, String id) {
        T entity = this.getEntity(categoryId, id);
        if (entity == null) {
            return null;
        }
        return this.toIndex(entity);
    }

    public Index toIndex(T entity) {
        Index index = this.createIndex(entity);
        if (index != null) {
            this.extractEntity(entity, index);
            this.prepareIndex(index);
            if (index.getDate() == null) {
                index.setDate(new Date());
            }
        }
        return index;
    }

    protected Index prepareIndex(Index index) {
        List<DataFetcher> dataFetchers;
        CategoryFactory cf;
        BusinessFactory bf = this.businessFactories.get(index.getBusinessId());
        if (bf != null && (cf = bf.getCategoryFactory(index.getCategoryId())) != null && (dataFetchers = cf.getDataFetchers()) != null) {
            for (DataFetcher dataFetcher : dataFetchers) {
                try {
                    for (Map.Entry<String, Serializable> entry : dataFetcher.fetchData(index.getId()).entrySet()) {
                        String key = entry.getKey();
                        if (cf.getUnSearchableFields().contains(key)) {
                            index.addField(key, entry.getValue());
                            continue;
                        }
                        index.addSearchableField(key, entry.getValue());
                    }
                }
                catch (RuntimeException e) {
                    this.logger.error("fetch data from form " + dataFetcher.getDescription() + " error", (Throwable)e);
                }
            }
        }
        return index;
    }

    public Category getDefaultCategory() {
        return this.defaultBusiness.getCategories().get(0);
    }

    public Business getDefaultBusiness() {
        return this.defaultBusiness;
    }

    protected Index createIndex(T entity) {
        return new Index();
    }

    protected abstract T getEntity(String var1, String var2);

    protected abstract void extractEntity(T var1, Index var2);

    protected abstract List<T> getEntities(String var1, int var2, int var3);
}

