package com.gtis.spring;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-3-23
 */

import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * Annotation for Bean definition Inheritance - must be processed by a
 * BeanFactoryPostProcessor prior to Instantiation of the Beans<br>
 * Indicates that this bean is ChildOf the named parent Bean and inherits all
 * (set) properties of the parent Class
 *
 * @author HAUSER
 * @since 2009-05-12
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface ChildOf {
    /**
     * The value may indicate a suggestion for a logical component name,
     * to be turned into a Spring bean in case of an autodetected component.
     *
     * @return the suggested component name, if any
     */
    String value() default "";

    /**
     * The name of the parent bean - must NOT be null
     *
     * @return the parent beanname
     */
    String parent() default "";
}
