package com.gtis.plat.service;

import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;

import java.util.List;

public interface SysWorkFlowDefineService {

    /**
     * 获取所有的业务
     *
     * @return
     */
    public abstract List<PfBusinessVo> getBusinessList();

    /**
     * 获取所有的业务但没有业务的连接信息
     * @return
     */
    public abstract List<PfBusinessVo> getBusinessSimpleList();

    /**
     * 获取业务详细信息
     *
     * @param bId
     * @return
     */
    public abstract PfBusinessVo getBusiness(String bId);

    /**
     * 根据业务获取该业务下的流程定义
     *
     * @param bId
     * @return
     */
    public abstract List<PfWorkFlowDefineVo> getWorkFlowDefineByBusiness(
            String bId);

    /**
     * 获取所有的流程定义
     *
     * @return
     */
    public abstract List<PfWorkFlowDefineVo> getWorkFlowDefineList();

    /**
     * 获取流程定义的详细信息
     *
     * @param workDefineId
     * @return
     */
    public abstract PfWorkFlowDefineVo getWorkFlowDefine(String workDefineId);

    /**
     * 获取流程定义，根据用户的所有的角色
     *
     * @param roleIds
     * @param resourceId
     * @param bId
     * @return
     */
    public abstract List<PfWorkFlowDefineVo> getWorkFlowDefineListByRole(
            String roleIds, String resourceId, String bId);


    public abstract String getWorkFlowDefineXml(String workDefineId);

    /**
     * 工作流定义模型
     *
     * @param defineVo
     * @return
     */
    public abstract String getWorkFlowDefineXml(
            PfWorkFlowDefineVo defineVo);

    /**
     * 获取工作流定义事件xml
     *
     * @param defineVo
     * @return
     */
    public abstract String getWorkFlowDefineEventXml(PfWorkFlowDefineVo defineVo);

    public abstract PfWorkFlowDefineVo getWorkFlowImage(String workDefineId);

    /**
     * 根据工作流程定义编号查找
     *
     * @param definitionNo 工作流程编号
     * @return
     */
    public abstract PfWorkFlowDefineVo getWorkFlowByDefinitionNo(
            String definitionNo);

    /**
     * 返回活动定义的XML
     *
     * @param workDefineId
     * @return
     */
    public String getWorkFlowDefineLocation(String workDefineId);

    /**
     * 获得需要监察的项目定义列表
     *
     * @return
     */
    public List<PfWorkFlowDefineVo> getECWorkFlowDefineList();
}