package com.gtis.plat.service;

import com.gtis.plat.vo.PfStuffFileVo;
import com.gtis.plat.vo.PfStuffInfoVo;

/**
 * @(#)StuffService.java 11-5-4 下午2:43
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public interface StuffService {

    /**
     * 根据infoId获取收件信息对象
     *
     * @param infoid
     * @return
     */
    PfStuffInfoVo getStuffInfo(String infoid);

    /**
     * 根据proid获取收件信息对象
     *
     * @param proid
     * @return
     */
    PfStuffInfoVo getStuffInfoByProId(String proid);

    /**
     * 根据proid,taskid获取收件信息对象
     *
     * @param proid
     * @param taskid
     * @return
     */
    PfStuffInfoVo getStuffInfoByProId(String proid, String taskid);

    /**
     * 保存收件信息
     *
     * @param info
     * @return
     */
    PfStuffInfoVo save(PfStuffInfoVo info);

    /**
     * 保存收文附件
     *
     * @param file
     * @return
     */
    PfStuffFileVo save(PfStuffFileVo file);

    /**
     * 删除收件类型
     *
     * @param file
     */
    void delete(PfStuffFileVo file);
}
