package com.gtis.plat.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import java.io.Writer;

/**
 * @(#)RssResult.java 2010-5-31 14:42:02
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					: 自定义Struts2返回类型，提供Rss返回
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class RssResult implements Result {

    private static final long serialVersionUID = 2985932211008610312L;

    /**
     * 日志记录
     */
    private static final Log log = LogFactory.getLog(RssResult.class);
    /**
     * 需获得的变量名
     */
    private String feedName = "feed";
    /**
     * Rss版本
     */
    private String feedType = "rss_2.0";

    /**
     * 输出Rss
     *
     * @param invocation
     * @throws Exception
     */
    public void execute(ActionInvocation invocation) throws Exception {
        ServletActionContext.getResponse().setContentType("text/xml");
        Object obj = invocation.getStack().findValue(feedName);
        if (obj != null) {
            SyndFeed feed = (SyndFeed) obj;
            feed.setFeedType(feedType);
            SyndFeedOutput output = new SyndFeedOutput();
            Writer out = null;
            try {
                out = ServletActionContext.getResponse().getWriter();
                output.output(feed, out);
            } catch (Exception e) {
                log.error("Could not write the rss", e);
            } finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public String getFeedName() {
        return feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public String getFeedType() {
        return feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }
}
