/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: JsonUtils.java
 *
 * LastModified: 2009-09-23 03:33:34
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.util;

import com.alibaba.fastjson.JSON;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-21
 */
public class JsonUtils {

    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    private static final String ENCODING_DEFAULT = "UTF-8";
    private static final boolean NOCACHE_DEFAULT = true;
    private static final String CONTENT_TYPE = "text/json;charset=";

    public static String toString(Object obj) {
        return JSON.toJSONString(obj);
    }

    public static void out(HttpServletResponse response, Object obj) {
        try {
            String encoding = ENCODING_DEFAULT;
            boolean noCache = NOCACHE_DEFAULT;
            response.setContentType(CONTENT_TYPE + encoding);
            if (noCache) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0);
            }
            response.getWriter().write(obj instanceof String ? (String) obj : toString(obj));
            response.getWriter().flush();
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static void out(Object obj) {
        HttpServletResponse response = ServletActionContext.getResponse();
        out(response, obj);
    }
}
