package com.gtis.common.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

/**
 * 对ObjectInputStream的功能增强,受到了JBoss的启发<br>
 *
 * @author shengw
 */
public class ObjectInputStreamWithClassLoader extends ObjectInputStream {

    Log log = LogFactory.getLog(getClass());
    private ClassLoader cl;

    /**
     * 构造函数,传入inputStream和类加载器
     *
     * @param in
     * @param cl
     * @throws IOException
     */
    public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl)
            throws IOException {
        super(in);
        this.cl = cl;
    }

    /**
     * 从使用的类加载器中获取类对象
     */
    protected Class resolveClass(ObjectStreamClass osc) throws IOException,
            ClassNotFoundException {
        if (osc.getName().equals("[Ljava.lang.Object;")) {
            return (new Object[]
                    {}).getClass();
        } else
            return cl.loadClass(osc.getName());
    }

    protected Class resolveProxyClass(String interfaces[]) throws IOException,
            ClassNotFoundException {
        Class interfacesClass[] = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; i++)
            interfacesClass[i] = Class.forName(interfaces[i], false, cl);

        return Proxy.getProxyClass(cl, interfacesClass);
    }

}
