package com.gtis.common.pagination.impl;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-12
 */
public class OraclePaginationSQLGetter extends GeneralPaginationSQLGetter {
    public String getCountSQL(String originalSql) {
        StringBuilder sql = new StringBuilder(" SELECT count(0) FROM ( ");
        sql.append(originalSql);
        sql.append(" )");
        return sql.toString();
    }

    public String getPaginationSQL(String originalSql, int first, int pageSize) {
        StringBuilder sql = new StringBuilder(" SELECT * FROM (");
        sql.append("SELECT temp.*,ROWNUM num FROM (");
        sql.append(originalSql);
        int last = first + pageSize;
        sql.append(") temp where ROWNUM<=").append(last);
        sql.append(") WHERE num>").append(first);
        return sql.toString();
    }
}
