/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.image.impl;

import com.gtis.generic.image.ImageTransform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwtImageTransform
implements ImageTransform {
    private static final Logger logger = LoggerFactory.getLogger(AwtImageTransform.class);
    private BufferedImage srcBImage;
    private BufferedImage destBImage;
    private int imgWidth;
    private int imgHeight;

    public boolean load(String srcFilePath) {
        try {
            this.srcBImage = ImageIO.read(new File(srcFilePath));
            this.imgWidth = this.srcBImage.getWidth();
            this.imgHeight = this.srcBImage.getHeight();
        }
        catch (IOException e) {
            logger.info("Cannot open image [{}]", (Object)srcFilePath);
            return false;
        }
        return true;
    }

    public boolean save(String destFilePath) {
        if (this.destBImage == null) {
            return false;
        }
        try {
            String postfix = destFilePath.substring(destFilePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)this.destBImage, postfix, new File(destFilePath));
        }
        catch (IOException e) {
            logger.info("Cannot open image [{}]", (Object)destFilePath);
            return false;
        }
        return true;
    }

    public void resize(int width, int height) {
        double xRatio = (double)height / (double)this.imgHeight;
        double yRatio = (double)width / (double)this.imgWidth;
        double ratio = xRatio < yRatio ? xRatio : yRatio;
        this.zoomImage(this.imgWidth, this.imgHeight, ratio);
    }

    public void rotate(double rotate) {
        this.rotateImage(this.imgWidth, this.imgHeight, rotate, 0);
    }

    public void resizeWithMaxWidth(int maxWidth) {
        if (this.imgWidth > maxWidth) {
            double ratio = (double)maxWidth / (double)this.imgWidth;
            this.zoomImage(this.imgWidth, this.imgHeight, ratio);
        } else {
            this.destBImage = this.srcBImage;
        }
    }

    public void rotateWithMaxWidth(double rotate, int maxWidth) {
        this.rotateImage(this.imgWidth, this.imgHeight, rotate, maxWidth);
    }

    private void zoomImage(int width, int height, double ratio) {
        try {
            int w = (int)((double)width * ratio);
            int h = (int)((double)height * ratio);
            this.destBImage = new BufferedImage(w, h, 1);
            Graphics2D g = this.destBImage.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
            this.destBImage.getGraphics().drawImage(this.srcBImage.getScaledInstance(w, h, 4), 0, 0, null);
        }
        catch (Exception e) {
            throw new ImagingOpException("Unable to transform src image");
        }
    }

    private void rotateImage(int width, int height, double rotate, int maxWidth) {
        double radian = rotate * Math.PI / 180.0;
        double h = (double)height * Math.cos(radian) + (double)width * Math.sin(radian);
        double w = (double)height * Math.sin(radian) + (double)width * Math.cos(radian);
        double ratio = maxWidth != 0 && w > (double)maxWidth ? (double)maxWidth / w : 1.0;
        AffineTransform transform = new AffineTransform();
        transform.setToScale(ratio, ratio);
        transform.rotate(radian, w / 2.0, h / 2.0);
        transform.translate(w / 2.0 - (double)(width / 2), h / 2.0 - (double)(height / 2));
        AffineTransformOp ato = new AffineTransformOp(transform, null);
        w *= ratio;
        h *= ratio;
        try {
            this.destBImage = new BufferedImage((int)w, (int)h, this.srcBImage.getType());
            Graphics gs = this.destBImage.getGraphics();
            gs.setColor(Color.white);
            gs.fillRect(0, 0, (int)w, (int)h);
            ato.filter(this.srcBImage, this.destBImage);
        }
        catch (Exception e) {
            throw new ImagingOpException("Unable to transform src image");
        }
    }
}

