/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.cache;

import com.gtis.generic.cache.EntityLoader;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheUtils {
    public static final String SEPARATOR = "^";

    public static String getKey(Object ... keys) {
        return StringUtils.join((Object[])keys, (String)SEPARATOR);
    }

    public static long getExpirationTime(Ehcache cache, Object key) {
        Element element = cache.get(key);
        if (element != null) {
            return element.getExpirationTime();
        }
        return 0L;
    }

    public static <T> T load(Ehcache cache, Object key) {
        return CacheUtils.load(cache, key, null, null);
    }

    public static <T> T load(Ehcache cache, Object key, EntityLoader loader) {
        return CacheUtils.load(cache, key, loader, null);
    }

    public static <T> T load(Ehcache cache, Object key, EntityLoader loader, Integer expire) {
        Element element = cache.get(key);
        if (element != null) {
            return (T)element.getObjectValue();
        }
        if (loader == null) {
            return null;
        }
        Object value = loader.loadOnMiss();
        if (value == null) {
            return null;
        }
        CacheUtils.put(cache, key, value, expire);
        return (T)value;
    }

    public static void put(Ehcache cache, Object key, Object value) {
        CacheUtils.put(cache, key, value, null);
    }

    public static void put(Ehcache cache, Object key, Object value, Integer expire) {
        cache.put(expire == null ? new Element(key, value) : new Element(key, value, null, expire, expire));
    }
}

