package com.gtis.util;


import com.gtis.spring.Container;
import org.apache.commons.logging.LogFactory;

import javax.sql.DataSource;
import java.sql.*;


public class DataSourceManager {

    private static final org.apache.commons.logging.Log log = LogFactory.getLog(DataSourceManager.class);

    private static DataSourceManager dm = null;


    //	private static DataSourceManager getInstance() throws Exception
//	{
//		if (dm == null)
//		{
//			dm = new DataSourceManager();
//			// ClassPathResource res = new
//			// ClassPathResource("applicationContext.xml");
//
////			URL url = DataSourceManager.class.getResource("DataSourceManager.class");
////			String path = url.getPath();
////			if (path.indexOf("classes")>-1){
////			String classesPath = path.substring(1, path.indexOf("classes"));
////			classesPath = java.net.URLDecoder.decode(classesPath, "UTF-8");
////
////			String configFilePath ="";// classesPath + "applicationContext.xml";
////			configFilePath=ResourceFileLoader.getResourceFileName();
////			factory = new FileSystemXmlApplicationContext(configFilePath);
//		}
//		return dm;
//	}
//
//	/**
//	 * 获取web用数据源，平台数据源
//	 * 
//	 * @param sc
//	 * @return
//	 * @throws SQLException
//	 */
//	public static DataSource getWebDataSource(HttpServletRequest request) throws SQLException
//	{
//		return getWebDataSource(request, "egov");
//	}
//
//	/**
//	 
//	 * 获取web用数据源，根据数据源名称获取
//	 * 
//	 * @param sc
//	 * @param alias
//	 * @return
//	 * @throws SQLException
//	 */
//	public static DataSource getWebDataSource(HttpServletRequest request, String alias) throws SQLException
//	{
//		DataSource ds = (DataSource) Container.getBean(alias);
//		return ds;
//	}
//
//	/**
//	 * 获取单元测试用数据源，平台数据源
//	 * 
//	 * @return
//	 * @throws SQLException
//	 */
    public static DataSource getDataSource() throws Exception {
        return getDataSource("egov");
    }

    //
//	/**
//	 * 获取单元测试用数据源，根据数据源名称获取
//	 * 
//	 * @param alias
//	 * @return
//	 * @throws SQLException
//	 */
    public static DataSource getDataSource(String alias) throws Exception {
        return (DataSource) Container.getBean(alias);
    }

    public static void attemptClose(Connection conn) {
        try {
            if (conn != null)
                conn.close();
        } catch (SQLException e) {
            log.error("closeConnection error, " + e.getMessage());
        }
    }

    public static synchronized void attemptClose(ResultSet o) {
        try {
            if (o != null)
                o.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void attemptClose(Statement o) {
        try {
            if (o != null)
                o.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void attemptClose(PreparedStatement o) {
        try {
            if (o != null)
                o.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//	public static void main(String args[]) throws Exception
//	{
//		//设置测试代码
//		StringBuffer sb=new StringBuffer();
//		URL url = DataSourceManager.class.getResource("DataSourceManager.class");
//		String path = url.getPath();
//		if (path.indexOf("classes")>-1)
//		{
//			String classesPath = path.substring(1, path.indexOf("classes"));
//			classesPath = java.net.URLDecoder.decode(classesPath, "UTF-8");
//			sb.append(classesPath);
//			
//		}
//		
//		sb.append("classes/conf/spring");
//
//		//获取路径中配置文件
//		File f=new File(sb.toString());
//		String[] filepath=new String[f.list().length];
//		for(int i=0;i<filepath.length;i++)
//		{
//			filepath[i]=f.listFiles()[i].getPath();
//		}
//		
//		
//		//加载spring配置文件
//		ApplicationContext ctx=new FileSystemXmlApplicationContext(filepath);
//		
//		SysWorkFlowActivityDAO sywfacdao=(SysWorkFlowActivityDAO)ctx.getBean("SysWorkFlowActivityDAO");
//		
////		List  ttlist=new ArrayList();
////		ttlist.add("1");
////		ttlist.add("2");
////		ttlist.add("3");
////		
////		
////		sywfacdao.insertTests(ttlist);
//		
//
//		
//
//	}

}
