package com.gtis.search;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class Index implements Serializable {
    private static final long serialVersionUID = -4191156991215104794L;
    public static final Pattern TRIM_TAG_PATTERN = Pattern.compile("<.*?>");
    public static final String[] DEFAULT_OWNER_IDS = new String[]{"0"};

    private String id;
    private MimeType mimeType = MimeType.TEXT;
    private String businessId;
    private String categoryId;
    private String[] ownerIds = DEFAULT_OWNER_IDS;
    private String title;
    private String body;
    private Date date;
    private boolean isPublic = true;
    private Map<String, Serializable> searchableFields = new LinkedHashMap<String, Serializable>();
    private Map<String, Serializable> fields = new HashMap<String, Serializable>();

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MimeType getMimeType() {
        return mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String[] getOwnerIds() {
        return ownerIds;
    }

    public void setOwnerIds(String[] ownerIds) {
        this.ownerIds = ownerIds;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void appendBody(String text) {
        appendBody(text, -1);
    }

    public void appendBody(String text, int maxLength) {
        if (StringUtils.isNotBlank(text)) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty(body)) {
                sb.append(body).append(" ");
            }
            if (maxLength > 0) {
                text = StringUtils.left(trimTag(text), maxLength);
            }
            sb.append(text);
            body = sb.toString();
        }
    }

    public void insertBody(String text) {
        insertBody(text, -1);
    }

    public void insertBody(String text, int maxLength) {
        if (StringUtils.isNotBlank(text)) {
            if (maxLength > 0) {
                text = StringUtils.left(trimTag(text), maxLength);
            }
            StringBuilder sb = new StringBuilder(text);
            if (StringUtils.isNotEmpty(body)) {
                sb.append(" ").append(body);
            }
            body = sb.toString();
        }
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isPublic() {
        return isPublic;
    }

    public void setPublic(boolean aPublic) {
        isPublic = aPublic;
    }

    public Map<String, Serializable> getFields() {
        return fields;
    }

    public Map<String, Serializable> getSearchableFields() {
        return searchableFields;
    }

    public void addField(String name, Serializable value) {
        if (value != null)
            fields.put(name, value);
    }

    public void addSearchableField(String name, Serializable value) {
        if (value != null)
            searchableFields.put(name, value);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + id + "," + title + "," + businessId + "," + categoryId + "]";
    }

    public static String trimTag(String s) {
        if (s == null) {
            return null;
        }
        return TRIM_TAG_PATTERN.matcher(s).replaceAll("");
    }
}
