package com.gtis.search;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class DefaultBusinessFactory extends AbstractIndexTemplateSupport implements BusinessFactory {
    protected Business business;
    protected Map<String, CategoryFactory> categoryFactories = new HashMap<String, CategoryFactory>();

    public DefaultBusinessFactory() {
        business = new Business();
        business.setLastModified(System.currentTimeMillis());
    }

    public void setId(String id) {
        business.setId(id);
    }

    public void setName(String name) {
        business.setName(name);
    }

    public void setIcon(String icon) {
        business.setIcon(icon);
    }

    public void setUpdateable(boolean updateable) {
        if (updateable)
            business.setLastModified(null);//为null表示每次更新都重载
    }

    @Override
    public void setTplVars(Map<String, Serializable> vars) {
        business.setTplVars(vars);
    }

    @Override
    public void setTplText(String name, String text) {
        business.addTpl(name, StringUtils.replace(text, "%{", "${"));
    }

    public void setCategoryFactories(List<CategoryFactory> categoryFactories) {
        for (CategoryFactory cf : categoryFactories) {
            this.categoryFactories.put(cf.getId(), cf);
        }
    }

    public String getId() {
        return business.getId();
    }

    public Business getBusiness() {
        List<Category> categories = business.getCategories();
        categories.clear();
        if (categoryFactories != null) {
            for (CategoryFactory factory : categoryFactories.values()) {
                categories.add(factory.getCategory(business));
            }
        }
        if (categories.isEmpty()) {
            Category cat = new Category();
            cat.setId(business.getId());
            cat.setBusinessId(business.getId());
            categories.add(cat);
        }
        prepareBusiness(business);
        return business;
    }

    public CategoryFactory getCategoryFactory(String categoryId) {
        return categoryFactories.get(categoryId);
    }

    protected void prepareBusiness(Business business) {
        reloadTpl();
    }
}
