package com.gtis.plat.vo;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;

import java.util.HashSet;
import java.util.List;
import java.util.Set;


public class UserInfo implements UserDetails {

    private static final long serialVersionUID = 6706995759718529112L;
    public static final GrantedAuthority USER = new GrantedAuthorityImpl("ROLE_USER");
    public static final GrantedAuthority ADMIN = new GrantedAuthorityImpl("ROLE_ADMIN");

    private String id;
    private String username;
    private String password;
    private boolean isAdmin = false;
    private String usersIdAll;  //所有的用户Id，包括代理用户
    private String roleIds;   //所有的角色集合，包括代理角色
    private List<PfOrganVo> lstOragn;
    private List<PfRoleVo> lstRole;
    private PfConfigVo config;

    private String regionCode;
    private Set<GrantedAuthority> authorities;

    public PfConfigVo getConfig() {
        return config;
    }

    public void setConfig(PfConfigVo config) {
        this.config = config;
    }

    public String getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(String roleIds) {
        this.roleIds = roleIds;
    }

    public String getUsersIdAll() {
        return usersIdAll;
    }

    public void setUsersIdAll(String usersIdAll) {
        this.usersIdAll = usersIdAll;
    }

    public List<PfOrganVo> getLstOragn() {
        return lstOragn;
    }

    public void setLstOragn(List<PfOrganVo> lstOragn) {
        this.lstOragn = lstOragn;
    }

    public List<PfRoleVo> getLstRole() {
        return lstRole;
    }

    public void setLstRole(List<PfRoleVo> lstRole) {
        this.lstRole = lstRole;
    }

    public boolean isAdmin() {
        return isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<GrantedAuthority> getAuthoritySet() {
        if (authorities == null) {
            initAuthorities();
        }
        return authorities;
    }

    public boolean hasRole(String roleName) {
        if (authorities == null) {
            initAuthorities();
        }
        return authorities.contains(new GrantedAuthorityImpl(roleName));
    }

    public GrantedAuthority[] getAuthorities() {
        if (authorities == null) {
            initAuthorities();
        }
        return authorities.toArray(new GrantedAuthority[authorities.size()]);
    }

    public String getPassword() {
        return password;
    }

    public String getUsername() {
        return username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    private void initAuthorities() {
        authorities = new HashSet<GrantedAuthority>();
        authorities.add(USER);
        if (isAdmin) {
            authorities.add(ADMIN);
        }
        if (lstRole != null) {
            for (PfRoleVo role : lstRole) {
                authorities.add(new GrantedAuthorityImpl(role.getRoleName()));
            }
        }
    }
}
