package com.gtis.ibatis;

import com.gtis.sql.dialect.Dialect;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * SqlExecutor的继承,分页查询的时候使用方言,<br>
 * 直接利用对应数据库本身支持的分页查询
 *
 * @author C4ISR
 */
public class SplitSqlExecutor extends SqlExecutor {

    private static final Log logger = LogFactory.getLog(SplitSqlExecutor.class);

    /**
     * 方言转换器
     */
    private Dialect dialect;

    private boolean enableLimit = true;

    public Dialect getDialect() {
        return dialect;
    }

    /**
     * 使用Spring进行依赖注入
     *
     * @param dialect
     */
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public boolean isEnableLimit() {
        return enableLimit;
    }

    public void setEnableLimit(boolean enableLimit) {
        // SqlMapExecutor t;
        this.enableLimit = enableLimit;
    }

    public boolean supportsLimit() {
        if (enableLimit && dialect != null) {
            return dialect.supportsLimit();
        }
        return false;
    }

    @Override
    public void executeQuery(StatementScope stateScope, Connection conn,
                             String sql, Object[] parameters, int skipResults, int maxResults,
                             RowHandlerCallback callback) throws SQLException {
        if ((skipResults != NO_SKIPPED_RESULTS || maxResults != NO_MAXIMUM_RESULTS)
                && supportsLimit()) {
            // 重新设置SQL语句,使得该SQL语句直接完成分页操作
            sql = dialect.getLimitString(sql, skipResults, maxResults);
            logger.debug(sql);
            skipResults = NO_SKIPPED_RESULTS;
            maxResults = NO_MAXIMUM_RESULTS;
        }
        super.executeQuery(stateScope, conn, sql, parameters, skipResults,
                maxResults, callback);
    }

//	public void executeQuery(StatementScope stateScope, Connection conn,
//			String sql, Object[] parameters, int skipResults, int maxResults,
//			RowHandlerCallback callback,String orderField,boolean desc) throws SQLException {
//		if ((skipResults != NO_SKIPPED_RESULTS || maxResults != NO_MAXIMUM_RESULTS)
//				&& supportsLimit()) {
//			// 重新设置SQL语句,使得该SQL语句直接完成分页操作
//			sql = dialect.getLimitString(sql, skipResults, maxResults,
//					orderField,desc);
//			logger.debug(sql);
//			skipResults = NO_SKIPPED_RESULTS;
//			maxResults = NO_MAXIMUM_RESULTS;
//		}
//		super.executeQuery(stateScope, conn, sql, parameters, skipResults,
//				maxResults, callback);
//	}

}
