/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ImageTransformFactory.java
 *
 * LastModified: 2009-09-23 06:03:49
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.image;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 图像转换的工厂类.
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 */
public class ImageTransformFactory {

    /**
     * 默认转换工具类的名称.
     */
    public static final String defaultImageTransform = "com.gtis.generic.image.impl.AwtImageTransform";

    /**
     * Logger.
     */
    private final static Log log = LogFactory.getLog(ImageTransformFactory.class);

    /**
     * 图像转换的实现类.
     */
    private static Class imageTransformClazz;

    /**
     * 同步对象.
     */
    private static final Object imageTransformLock = new Object();

    /**
     * 设置图像转换的实现类.
     *
     * @param className 图像转换的实现类.
     */
    public static void setTransformProvider(final String className) {
        try {
            imageTransformClazz = Class.forName(className);
        } catch (Exception e) {
            log.error("Invalid provider class of image transforming.", e);
        }
    }

    /**
     * 获取图像转换的实现类.
     *
     * @return 图像转换的实现类.
     */
    public static ImageTransform getImageTransform() {
        if (imageTransformClazz == null) {
            synchronized (imageTransformLock) {
                // double check.
                if (imageTransformClazz == null) {
                    setTransformProvider(defaultImageTransform);
                }
            }
        }
        try {
            return (ImageTransform) imageTransformClazz.newInstance();
        } catch (Exception e) {
            log.error("instance class error", e);
        }
        return null;
    }
}
