package com.gtis.generic.cache;

import net.sf.ehcache.Ehcache;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-10-13
 */
public class Cache<E> {

    protected Ehcache cache;

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }

    public Cache(Ehcache cache) {
        this.cache = cache;
    }

    public E load(Object... keys) {
        return CacheUtils.load(cache, getKey(keys));
    }

    @SuppressWarnings("unchecked")
    public E load(EntityLoader<E> loader, Object... keys) {
        return (E) CacheUtils.load(cache, getKey(keys), loader, null);
    }

    public E put(E value, Object... keys) {
        CacheUtils.put(cache, getKey(keys), value, null);
        return value;
    }

    public boolean exist(Object... keys) {
        return cache.isKeyInCache(getKey(keys));
    }

    public void clear(Object... keys) {
        cache.remove(getKey(keys));
    }

    protected String getKey(Object... keys) {
        return CacheUtils.getKey(keys);
    }
}
