/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MimeTypeService.java
 *
 * LastModified: 2009-09-21 03:15:36
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.service;

/**
 * mimeType获取服务
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public interface MimeTypeService {

    public static final String MIMETYPE_BINARY = "application/octet-stream";
    public static final String ICON_UNKOWN = "unknow.gif";

    /**
     * 根据mimeType获取扩展名
     *
     * @param mimeType mine类型
     * @return 扩展名
     */
    public String getExtension(String mimeType);

    /**
     * 根据文件名获取图标
     *
     * @param fileName 文件名
     * @return 图标
     */
    public String getIcon(String fileName);

    /**
     * 根据文件名获取mimeType
     *
     * @param fileName 文件名
     * @return mine类型
     */
    public String getMimeType(String fileName);
}
