package com.gtis.common.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class CommonUtil {

    public static String toNumber(double value, int afterpoint) {
        double doubleValue = value;
        int N = afterpoint;
        boolean ForceToN = true;
        boolean ReturnZero = false;
        String ret = (new StringBuilder(String.valueOf(doubleValue))).toString();
        boolean IsZero = doubleValue == 0.0D;
        try {
            BigDecimal b = new BigDecimal(Double.toString(doubleValue));
            BigDecimal one = new BigDecimal("1");
            double aa = b.divide(one, N, 4).doubleValue();
            StringBuffer sb = new StringBuffer();
            sb.append("###");
            if (N > 0) {
                sb.append(".");
                for (int i = 1; i <= N; i++)
                    sb.append("#");
            }
            DecimalFormat df = new DecimalFormat(sb.toString());
            String tempValue = df.format(aa);
            ret = tempValue;
            if (ForceToN && N > 0) {
                if (ret.indexOf(".") < 0)
                    ret = (new StringBuilder(String.valueOf(ret))).append(".0").toString();
                for (; ret.substring(ret.indexOf(".") + 1, ret.length()).length() < N; ret = (new StringBuilder(String.valueOf(ret))).append("0").toString()) ;
            }
        } catch (Exception e) {
            e.printStackTrace();
            ret = (new StringBuilder(String.valueOf(doubleValue))).toString();
        }
        if (!ForceToN) {
            for (; ret.endsWith("0"); ret = ret.substring(0, ret.length() - 1)) ;
            if (ret.endsWith("."))
                ret = ret.substring(0, ret.length() - 1);
        }
        if (IsZero && !ReturnZero)
            return "";
        if (IsZero && ReturnZero)
            return "0";
        else
            return ret;
    }

    /**
     * @param doubleData 字符型的double
     *                   count
     *                   保留小数位数
     * @return
     */
    public static String formartDoubleString(String doubleData, int count) {

        double input = 0.0;

        DecimalFormat myformat = null;

        if (doubleData != null && !"".equals(doubleData)) {
            input = Double.parseDouble(doubleData);
        }

        switch (count) {
            case 0:
                myformat = new java.text.DecimalFormat("#0");
                break;
            case 1:
                myformat = new java.text.DecimalFormat("#0.0");
                break;
            case 2:
                myformat = new java.text.DecimalFormat("#0.00");
                break;
            case 3:
                myformat = new java.text.DecimalFormat("#0.000");
                break;
            case 4:
                myformat = new java.text.DecimalFormat("#0.0000");
                break;
            default:
                myformat = new java.text.DecimalFormat("#0.00");
                break;
        }
        return myformat.format(input);
    }

    public static String getCurrStrDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar today = new GregorianCalendar();
        String str = sdf.format(today.getTime());
        return str;
    }

    public static Date getCurrDate() {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar today = new GregorianCalendar();
        String str = sdf.format(today.getTime());
        try {
            date = sdf.parse(str);
        } catch (Exception e) {
            return null;
        }
        return date;
    }

    public static String getCurrTime() {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GregorianCalendar today = new GregorianCalendar();
        String str = sdf.format(today.getTime());
        return str;
    }

    public static Date formatDate(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String str = sdf.format(date);
        try {
            date = sdf.parse(str);
        } catch (Exception e) {
            return null;
        }
        return date;
    }

    public static String formateDate(java.sql.Date date) {
        String strDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        strDate = sdf.format(date);
        return strDate;
    }

    public static String formateDate(java.util.Date date) {
        String strDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        strDate = sdf.format(date);
        return strDate;
    }

    public static Date formateDateToStr(String dateString) {
        Date formateDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (dateString == null)
            return new Date();
        if (dateString.length() > 10 && dateString.length() < 20)
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            formateDate = sdf.parse(dateString);
        } catch (Exception ex) {
            ex.printStackTrace();
            return new Date();
        }
        return formateDate;
    }

    public static String formateDateToString(String dateString) {
        Date formateDate = null;
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            formateDate = format.parse(dateString);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return formateDate(formateDate);
    }

    public static String getCurrYear() {
        GregorianCalendar today = new GregorianCalendar();
        String curYear = "" + today.get(GregorianCalendar.YEAR);
        return curYear;
    }

    public static String getCurrMonth() {
        GregorianCalendar today = new GregorianCalendar();
        String currMonth = "" + today.get(GregorianCalendar.MONTH);
        return currMonth;
    }

    //获取年月星期，如2009043
    public static String getCurrYearMonthWeek() {
        GregorianCalendar today = new GregorianCalendar();

        String curYear = "" + today.get(GregorianCalendar.YEAR);
        String curMonth = "" + (today.get(GregorianCalendar.MONTH) + 1);
        String curWeek = "" + today.get(GregorianCalendar.WEEK_OF_MONTH);

        String CurrYearMonthWeek = curYear + curMonth + curWeek;

        return CurrYearMonthWeek;
    }

    public static String getCurrYearMonthDayHourMinute() {
        Date date = new Date(System.currentTimeMillis());

        DateFormat format = new SimpleDateFormat("yyyyMMddHHmm");

        return format.format(date);
    }

    /**
     * 获取子串
     *
     * @param src   原字符串
     * @param split 分隔符
     * @return
     */
    public static String getSubString(String src, String split) {
        if (src == null || "".equals(src)) {
            return "";
        } else if (src.indexOf(split) != -1) {
            src = src.substring(0, src.indexOf(split));
            return src;
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(CommonUtil.getCurrYearMonthDayHourMinute());
    }
}
