package com.gtis.archive.web;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.SecurityService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportAction implements Action {

    @Autowired
    protected DictService dictService;
    @Autowired
    private SecurityService securityService;

    private String type;

    private String dwdm;

    private  String userName;

    /**
     * 系统权限列表
     */
    private Map<String, Boolean> sysPerms;

    public String execute() throws Exception {
        dwdm = SessionUtil.getCurrentUser().getRegionCode();
        userName = SessionUtil.getCurrentUser().getUsername();
        return Action.SUCCESS;
    }

    public String getType() {
        if(type== null || StringUtils.isBlank(type)){
            if(typeList == null){
                typeList = getTypeList();
            }

            type = typeList.get(0).get("name");
        }
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Boolean> getSysPerms() {
        sysPerms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                sysPerms.put(item.getName(), true);
        }
        return sysPerms;
    }

    private List<Map<String, String>> typeList;

    public List<Map<String, String>> getTypeList() {
        try {
            if (typeList == null) {
                typeList = new ArrayList<Map<String, String>>();
                List<Item> itemList = dictService.getItems("report");
                if (itemList != null && itemList.size() > 0) {
                    for (Item item : itemList) {
                        Map<String, String> map = new HashMap<String, String>();
                        map.put("name", item.getName());
                        map.put("value", item.getValue());
                        typeList.add(map);
                    }
                } else {
                    Map<String, String> map = new HashMap<String, String>();
                    map.put("name", "static");
                    map.put("value", "档案分类统计");
                    typeList.add(map);

                    map = new HashMap<String, String>();
                    map.put("name", "effect");
                    map.put("value", "利用效果统计");
                    typeList.add(map);

                    map = new HashMap<String, String>();
                    map.put("name", "utilization");
                    map.put("value", "利用情况统计");
                    typeList.add(map);
                }
            }
        }catch(Exception e){
            if (typeList == null || typeList.size() == 0) {
                typeList = new ArrayList<Map<String, String>>();
                Map<String, String> map = new HashMap<String, String>();
                map.put("name", "static");
                map.put("value", "档案分类统计");
                typeList.add(map);

                map = new HashMap<String, String>();
                map.put("name", "effect");
                map.put("value", "利用效果统计");
                typeList.add(map);

                map = new HashMap<String, String>();
                map.put("name", "utilization");
                map.put("value", "利用情况统计");
                typeList.add(map);
            }
        }

        return typeList;
    }
}
