package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanAction extends BaseModelAction<Loan> {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private LoanService loanService;
    private String idString;

    public String getIdString() {
        return idString;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    /**
     * 列表要显示的字段
     */
    private Map showFields;

    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    /**
     * 审批状态
     */
    private int sfpz;

    /**
     * 借阅类型
     */
    private String loanType;
    private Integer state;

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public int getSfpz() {
        return sfpz;
    }

    public void setSfpz(int sfpz) {
        this.sfpz = sfpz;
    }

    public String getLoanType() {
        return loanType;
    }

    public void setLoanType(String loanType) {
        this.loanType = loanType;
    }

    //归还档案
    public String returnLoan() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            loan.setGhrq(new Date());
            entityService.save(loan);
        }
        return null;
    }

    /**
     *  获取借阅的内容
     */
    public void loanList() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        criterions.add(Restrictions.eq("userId", userInfo.getId()));
        criterions.add(Restrictions.eq("sfpz", sfpz));
        renderJson(loanService.pageLoan(start, limit, criterions));
    }

    /**
     * 审核通过
     */
    public void examed(){
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;

            Loan loan = entityService.load(Loan.class, id);
            loan.setSfpz(2);
            entityService.save(loan);
        }
    }

    /**
     * 审核不通过
     */
    public void unexamed(){
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;

            Loan loan = entityService.load(Loan.class, id);
            loan.setSfpz(1);
            entityService.save(loan);
        }
    }
    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected Page<Loan> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if("exam".equals(type)) {
            criterions.add(Restrictions.eq("sfpz", sfpz));
        }else if("view".equals(type)){
            criterions.add(Restrictions.eq("sfpz", 2));
            criterions.add(Restrictions.eq("loanType", dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
        }else if("loaned".equals(type)){
            criterions.add(Restrictions.eq("sfpz", 2));
            if(state != null )
            criterions.add(Restrictions.eq("state",state));
            criterions.add(Restrictions.eq("loanType", dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
        }else if("exceed".equals(type)){
            criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
            criterions.add(Restrictions.eq("sfpz", 2));
            criterions.add(Restrictions.eq("state", 0));
            criterions.add(Restrictions.eq("loanType", dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
        }else if("borrow".equals(type)) {
            criterions.add(Restrictions.eq("sfpz", sfpz));
        }

        if (query != null) {
            criterions.add(Restrictions.or(Restrictions.like("arc.tm", "%" + query + "%"), Restrictions.like("arc.dh", "%" + query + "%")));
        }

        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
        }

        //criterions.add(Restrictions.or(Restrictions.isNull("userId"), Restrictions.eq("userId", userInfo.getId())));
        return entityService.search(Loan.class, criterions, orders, start, limit);
    }

    @Override
    protected String[] getQueryFields() {
        return null;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public String execute() throws Exception {
        if (!securityService.isPermitted("sys", "loan")) {
            throw new NoPermissionException("没有权限访问借阅管理");
        }

        return super.execute();
    }
    public String toGetLoanByUser() {
        return "list";
    }
    /**
     * 获取用户已批准的借阅
     */
   public void getLoanByUser(){
       this.loanType = "0";
       String userId = SessionUtil.getCurrentUserId();
       List<Criterion> criterions =createCriterions(new ArrayList<Criterion>());
       criterions.add(Restrictions.sqlRestriction("jyrq+jyqx>=?", new Date(), StandardBasicTypes.DATE));
       criterions.add(Restrictions.eq("sfpz", 2));
       criterions.add(Restrictions.eq("state", 0));
       criterions.add(Restrictions.eq("userId",userId));
//       criterions.add(Restrictions.eq("loanType", dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
       Page<Loan> loans = entityService.search(Loan.class.getSimpleName(),criterions,null,start,limit);
       Struts2Utils.renderJson(loans);
   }
    public String toGetUnpass() {
        return "unpass";
    }
    //获取当前用户审批未通过的借阅
    public void getLoanUnpass(){
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        String userId = SessionUtil.getCurrentUserId();
        criterions.add(Restrictions.eq("userId",userId));
        criterions.add(Restrictions.eq("sfpz",1));
        Page<Loan> loans = entityService.search(Loan.class.getSimpleName(),criterions,null,start,limit);
        Struts2Utils.renderJson(loans);
    }
}
