package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-23
 */
public class ArchiveAction extends BaseModelAction<Archive> {
    private static final Object Lock = 0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private SqlServerService sqlServerService;
    @Autowired
    private PermissionService permissionService;

    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;
    /**
     * 所有定义的操作项
     */
    private List<Item> operations;
    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒盒号
     */
    private Integer boxId;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String wgdState = "false";

    /**
     * excel导入档案
     */
    private File upload;

    private String uploadFileName; //文件名称

    /**
     * 档案流程节点字典
     */
    private List<Item> flowDict;

    private Map<String, String> queryParam = new HashMap<String, String>();

    private Map<String, String> receivedParam = new HashMap<String, String>();

    /**
     * 机柜所在位置
     */
    private String jgszwz;

    /**
     * 操作机柜命令
     */
    private String cmd;

    /**
     * 分类号检索
     */
    private String flhjs;

    /**
     * 档号
     */
    private String dh;
    /**
     * 题名
     */
    private String tm;

    /**
     * 档案id
     */
    private String djDaId;

    /**
     * 原文所属ID
     */
    private String ownerId;

    /**
     * 原文所属业务模型名
     */
    private String ownerModelName;

    /**
     * 档案ids
     */
    private String[] archiveIds;

    public void setTm(String tm) {
        this.tm = tm;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public Integer getBoxId() {
        return boxId;
    }

    public void setBoxId(Integer boxId) {
        this.boxId = boxId;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public String getWgdState() {
        return wgdState;
    }

    public void setWgdState(String wgdState) {
        this.wgdState = wgdState;
    }

    public File getUpload() {
        return upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getFlhjs() {
        return flhjs;
    }

    public void setFlhjs(String flhjs) {
        this.flhjs = flhjs;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDjDaId() {
        return djDaId;
    }

    public void setDjDaId(String djDaId) {
        this.djDaId = djDaId;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public String[] getArchiveIds() {
        return archiveIds;
    }

    public void setArchiveIds(String[] archiveIds) {
        this.archiveIds = archiveIds;
    }

    public Map<String, String> getQueryParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("queryParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }

    }

    public Map<String, String> getReceivedParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("receivedParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }
    }

    public String getJgszwz() {
        return jgszwz;
    }

    public void setJgszwz(String jgszwz) {
        this.jgszwz = jgszwz;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getTddjPath() {
        return EnvHolder.getAppEnv().get(Switch.TDDJPATH);
    }

    public static Object getLock() {
        return Lock;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    /**
     * 获取查看流程url地址字典
     */
    public Map<String, Boolean> getFlow() {
        Map<String, Boolean> flow = new HashMap<String, Boolean>();
        for (Model model : modelService.getModels()) {
            flow.put(model.getName(), false);
        }
        for (Item item : flowDict) {
            flow.put(item.getName(), true);
        }
        return flow;
    }

    /**
     * 获取查看流程url地址字典备注
     */
    public void getFlowRemark() {
        String remark = null;
        flowDict = dictService.getItems(Permission.FLOW_DICT);
        for (Item item : flowDict) {
            if (item.getName().equals(modelName)) {
                remark = item.getRemark();
            }
        }
        renderJson(remark);
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }

        if (EnvHolder.isEnable(Switch.IMPORTEXCEL)) {
            List<String> menuList = new ArrayList<String>();
            for (Item item : dictService.getItems("importMenu")) {
                menuList.add(item.getName());
            }
            if (!menuList.contains(modelName)) {
                topMenu.remove("importExcel");
            }
        } else {
            topMenu.remove("importExcel");
        }
        return topMenu;
    }

    @Override
    public String execute() {
        operations = dictService.getItems(Permission.OPERATION_DICT);
        flowDict = dictService.getItems(Permission.FLOW_DICT);

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }

        if (EnvHolder.isEnable(Switch.WGDYW)) {
            List<Item> dictList = dictService.getItems("wgdyw");
            for (Item item : dictList) {
                if (item.getName().equalsIgnoreCase(modelName)) {
                    setWgdState("true");
                    break;
                }
            }
        }
        ServletActionContext.getRequest().getSession().setAttribute("username", SessionUtil.getCurrentUser().getUsername());
        return Action.SUCCESS;
    }

    /**
     * 归档
     * @return
     */
    public String gd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            AjhRange ajhRange = null;
            if (archive.getDh() == null && !EnvHolder.isEnable(Switch.NOT_NEED_AJH) && !EnvHolder.isEnable(Switch.LIAN_YUNGANG)) {  //连云港档案系统归档时，目录号、分类号及案卷号不变
                try {
                    if (PropertyUtils.isReadable(archive, "jnmllx")) {
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive);
                    } else {
                        if (!EnvHolder.isEnable(Switch.JIN_TAN)) {
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        } else {
                            if ("Tddj".equalsIgnoreCase(modelName) && getDwdm().length() == 6 && archive.getNd() != null) {
                                try {
                                    ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, archive.getNd());
                                } catch (Exception ex) {
                                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                                }
                            } else {
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        }
                    }
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }

                if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {       //notCheckAjh.enable=false 设置为此情况，所有业务都可以在添加之后更新业务
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                } else if (EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {  //notCheckAjh.enable=true 设置为此情况,当字典当中配置这个业务时就给这个业务更新案卷号
                    List<Item> dictList = dictService.getItems("increaseAjh");
                    boolean flag = false;
                    for (Item item : dictList) {
                        if (item.getName().equalsIgnoreCase(modelName)) {
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getCurrentValue());
                            flag = true;
                            break;
                        }

                        if (!flag) {
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getNextValue());
                        }
                    }
                }
            }
            //归档人及归档人id的写入
            if (EnvHolder.isEnable(Switch.HASGDR_GDRID)) {
                archive = this.setGdrAndGdrId(archive);
            }
            ////归档时是否自动添加案卷号
            if (EnvHolder.isEnable(Switch.AUTO_CREATE_AJH) && archive.getAjh() == null && archive.getMlh() != null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                } catch (EntityNotFoundException ex) {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }
            }
            if (EnvHolder.isEnable(Switch.AUTO_CREATE_CABINETSNO)) {
                archive = changeArchive(archive);
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
//            if (EnvHolder.isEnable(Switch.CREATEDHBYMODELNAME)) {
//                archive = this.createDhByArchive(archive);
//            }
            archiveService.saveArchive(archive);
            try {
                List<Document> documents = archiveService.getArchiveDocuments(modelName + "_jn", archive.getId());
                for (Document document : documents) {
                    document.setMlh(archive.getMlh());
                    document.setAjh(archive.getAjh());
                    archiveService.saveDocument(document);
                }
            } catch (Exception ex) {
                //不设置卷内的情况下

            }
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    /**
     * 撤销归档
     * @return
     */
    public String cxgd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(Archive.STATE_WGD);
            archive.setGdsj(null);
            if (EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) {
                archive.setMlh(null);
                archive.setAjh(null);
                archive.setDh(null);
            }
            archiveService.saveArchive(archive);
        }
        return null;
    }

    /**
     * 档案销毁
     *
     * @return
     */
    public String destroyArchive() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(8);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    /**
     * 快速归档
     *
     * @return
     * @throws Exception
     */
    public String fastGd() throws Exception {
        synchronized (Lock) {
            String id = getId();
            if (StringUtils.isNotBlank(id)) {
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setState(Archive.STATE_YGD);
                archive.setGdsj(new Date());
                AjhRange ajhRange = null;
                if (archive.getDh() == null) {
//                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    if (!EnvHolder.isEnable(Switch.JIN_TAN)) {
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    } else {
                        if ("Tddj".equalsIgnoreCase(modelName) && getDwdm().length() == 6 && archive.getNd() != null) {
                            try {
                                ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, archive.getNd());
                            } catch (Exception ex) {
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        } else {
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        }
                    }
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }
                if (EnvHolder.isEnable(Switch.HASGDR_GDRID)) {
                    archive = this.setGdrAndGdrId(archive);
                }
//                if (EnvHolder.isEnable(Switch.CREATEDHBYMODELNAME)) {
//                    archive = this.createDhByArchive(archive);
//                }
                archiveService.saveArchive(archive);
                if (ajhRange != null) {
                    ajhRange.setCurrentValue(archive.getAjh());
                    ajhRangeService.saveAjhRange(ajhRange);
                }
            }
        }
        return renderModelTemplate("fastGd");
    }

    public String move() {
        if (StringUtils.isBlank(treeId)) {
            treeId = null;
        }
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setResourceId(treeId);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    public String order() {
        AjhRange ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
        for (Archive archive : getEntities()) {
            if (!ajhRange.hasExhausted()) {
                ajhRangeService.saveAjhRange(ajhRange);
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            }
            archive.setAjh(ajhRange.getNextValue());
            archive.setDh(null);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
//        if(EnvHolder.isEnable(Switch.JIANGYIN)){
//            Page<Archive> page=archiveService.searchArchive(modelName, criterions, orders, start, limit);
//            for(Archive archive:page.getItems()){
//                archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
//            }
//            return page;
//        }else{
//            return archiveService.searchArchive(modelName, criterions, orders, start, limit);
//        }

        Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, start, limit);
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }

        return page;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh - 1));
            if (endAjh != null)
                criterions.add(Restrictions.lt("ajh", endAjh + 1));
            sort = "ajh";
        } else {
            if (type == null || !type.equals("all")) {
                criterions.add(Restrictions.eq("state", "ygd".equals(type) ? Archive.STATE_YGD : Archive.STATE_WGD));
            }
            if (mlh != null) {
                criterions.add(Restrictions.eq("mlh", mlh));
            }
            if (StringUtils.isNotBlank(treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    String[] treeIds = treeId.split(",");
                    if (treeIds.length == 1) {
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                        } else {
                            criterions.add(Restrictions.eq("resourceId", treeId));
                        }
                    } else {
                        if (treeIds.length > 2) {
                            Criterion temp = Restrictions.or(Restrictions.eq("resourceId", treeIds[0]), Restrictions.eq("resourceId", treeIds[1]));
                            for (int i = 2; i < treeIds.length; i++) {
                                temp = Restrictions.or(temp, Restrictions.eq("resourceId", treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeIds[0]), Restrictions.eq("resourceId", treeIds[1])));
                        }
                    }
                } else {
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                    } else {
                        criterions.add(Restrictions.eq("resourceId", treeId));
                    }
                }
            } else {
                criterions.add(Restrictions.isNull("resourceId"));
            }

            if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
                List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
                List<String> mlhs = new ArrayList<String>();
                String roleids = SessionUtil.getCurrentUser().getRoleIds();
                if (roleids != null) {
                    for (String roleid : roleids.split(",")) {
                        roleid = roleid.substring(1, roleid.length() - 1);
                        for (AjhRange ajhRange : ajhRanges) {
                            if (permissionService.getPermissions(ajhRange.getId(), roleid).size() != 0) {
                                mlhs.add(ajhRange.getMlh());
                            }
                        }
                    }

                    if (mlhs.size() > 0) {
                        String sSQL = "(";
                        for (String mlh : mlhs) {
                            sSQL = sSQL + "mlh = '" + mlh + "' OR ";
                        }
                        sSQL = sSQL.substring(0, sSQL.length() - 4);
                        sSQL = sSQL + ")";
                        criterions.add(Restrictions.sqlRestriction(sSQL));
                    }
                }
            }
        }

        return super.createCriterions(criterions);
    }

    /**
     * 分类号类型检索
     *
     * @return
     */
    public String searchFlh() {
        String flhtj = archiveService.flhjs(flhjs, modelName);
        renderJson(flhtj);
        return null;
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                for (Item item : operations) {
                    if (securityService.isPermitted(id, item.getName()))
                        perm.put(item.getName(), true);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
            }
        }
        return docFields;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }


    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }


    /**
     * 快速补件
     *
     * @return
     * @throws Exception
     */
    public String fastAddOG() throws Exception {
        //
        return renderModelTemplate("fastAddOG");
    }

    /**
     * 获取是否存在卷内案卷模型
     *
     * @return
     */
    public boolean getIsShowArchiveInfo() {
        try {
            if (modelService.getModel(modelName.concat("_ai")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }

        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 打印档案相关案卷信息
     *
     * @return
     * @throws IOException
     * @throws TemplateException
     */
    public String printArcDocs() throws IOException, TemplateException {
        try {
            return renderTemplate(getEntityModel().getTemplate("printArcDoc"));
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }


    /**
     * 检索数据后进行统一归档
     *
     * @return
     */
    public String gdAfterSearch() {
        List<Archive> list = getEntityPage().getItems();
        for (Archive archive : list) {
            AjhRange ajhRange = null;
            if (archive.getDh() == null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                }
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(ajhRange.getNextValue());
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
            archiveService.saveArchive(archive);
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }


    @Override
    public String remove() throws Exception {
        if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
            for (String id : ids) {
                Archive archive = archiveService.getArchive(modelName, id);
                if (archive.getAjh() != null && archive.getMlh() != null && archive.getModelName() != null) {
                    RecordAjhRange recordAjhRange = new RecordAjhRange();
                    recordAjhRange.setAjh(archive.getAjh());
                    recordAjhRange.setMlh(archive.getMlh());
                    recordAjhRange.setDwdm(archive.getDwdm());
                    recordAjhRange.setModelName(archive.getModelName());
                    recordAjhRange.setBgqx(archive.getBgqx());
                    recordAjhRangeService.saveRecordAjh(recordAjhRange);
                }
            }
        }
        super.remove();
//        archiveService.removeArchive(modelName, ids);
        return null;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     *
     * @return
     */
    public List getDocEntities() {
        if (docEntities != null) return docEntities;
        docEntities = new ArrayList();
        if (ids.length > 0) {
            for (String id : ids) {
                docEntities.addAll(archiveService.getArchiveDocuments(modelName, id));
            }
        }
        return docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank(idString))
            ids = idString.split(",");
    }

    /**
     * 过滤条件查询ｉｄ
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    /**
     * excel导入档案
     */
    public void importExcel() {
        String realpath = ServletActionContext.getServletContext().getRealPath("/WEB-INF");
        String msg = "";
        if (upload != null) {
            File savefile = new File(new File(realpath), uploadFileName);
            try {
                FileUtils.copyFile(upload, savefile);
                InputStream is = new FileInputStream(realpath + File.separator + uploadFileName);

                Workbook book = WorkbookFactory.create(is);
                List list = new ArrayList();
                // 循环工作表Sheet
                for (int numSheet = 0; numSheet < book.getNumberOfSheets(); numSheet++) {
                    Sheet sheet = book.getSheetAt(numSheet);
                    if (sheet == null) {
                        continue;
                    }

                    Map filedMap = new HashMap();

                    /**
                     * 存储所有属性信息，应用于和excel的表头进行比较
                     */
                    //获取第一行的头信息
                    Row row = sheet.getRow(0);
                    for (int titleNum = 0; titleNum < row.getLastCellNum(); titleNum++) {
                        for (Field field : modelService.getModel(modelName).getInheritfieldsMap().values()) {
                            if (row.getCell(titleNum) != null && (row.getCell(titleNum).toString().replaceAll(" ", "")).equals(field.getTitle())) {
                                filedMap.put(titleNum, field.getName());
                            }
                        }
                    }

                    /**
                     * 获取数据
                     */
                    for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); rowNum++) {
                        Object o = entityService.newInstance(modelName);
                        Row rows = sheet.getRow(rowNum);
                        if (rows == null) {
                            continue;
                        }

                        /**
                         * 循环取出所有的单元格的值并且判断类型赋值
                         */
                        for (int cellNum = 0; cellNum <= rows.getLastCellNum(); cellNum++) {
                            if (filedMap.get(cellNum) != null && rows.getCell(cellNum) != null) {
                                if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == String.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), null);
                                    } else {
                                        if ("nd".equals(filedMap.get(cellNum).toString())) {
                                            PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).toString().substring(0, rows.getCell(cellNum).toString().lastIndexOf(".")));
                                        } else {
                                            PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).toString());
                                        }
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Boolean.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getBooleanCellValue());
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Integer.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Integer.valueOf(Math.round(Float.valueOf(rows.getCell(cellNum).toString()))));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Float.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Float.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (rows.getCell(cellNum) == null || PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Double.class) {
                                    if ("".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Double.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Date.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getDateCellValue());
                                }
                            }
                        }
                        PropertyUtils.setProperty(o, "id", UUIDHexGenerator.generate());

                        //对象档号值都为空的不存储
                        if (PropertyUtils.getProperty(o, "dh") != null && PropertyUtils.getProperty(o, "dh") != "") {
                            list.add(o);
                        }
                    }
                }

                for (Object ob : list) {
                    entityService.save(ob);
                }
                msg = "导入成功";
            } catch (IOException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (InvocationTargetException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (IllegalAccessException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (Exception e) {
                e.printStackTrace();
                msg = "导入失败";
            } finally {
                if (savefile.exists()) {
                    savefile.delete();
                }
            }
        }

        renderJson(msg);
    }

    /**
     * 档案开启机柜
     */
    public void openBox() {
        Map result = null;
        try {
            result = sqlServerService.insertOpenCmd(jgszwz, cmd, SessionUtil.getCurrentUser().getUsername());
        } catch (Exception ex) {
            logger.error("open box with error:" + ex.toString());
        }

        renderJson(result);
    }

    /**
     * 获取单位代码
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && pfOrganVoList.size() > 0) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }

                dwdm = oraganNo;
            } else {
                dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            }
        }

        return dwdm;
    }

    /**
     * 保存盒号
     */
    private void saveBoxId() {
        try {
            Archive archive = archiveService.getArchiveByAjh(ajh, mlh);
            String dh = archive.getDh();
            archive.setBoxId(boxId);

            archiveService.saveArchive(archive);

            for (int i = 1; i < boxSize; i++) {
                if (dir.equals("ASC")) {
                    ajh = ajh + 1;
                } else {
                    ajh = ajh - 1;
                }

                archive = archiveService.getArchiveByAjh(ajh, mlh);
                archive.setBoxId(boxId);

                archiveService.saveArchive(archive);
            }
        } catch (Exception e) {
            logger.error("保存盒号出现异常" + e.toString());
        }

    }


    /**
     * 根据档号获取档案信息
     */
    public void boxDetail() {
        Archive archive = archiveService.getArchiveByDh(dh);
        Map archiveMap = new HashMap();
        archiveMap.put("modelName", archive.getModelName());
        archiveMap.put("mlh", archive.getMlh());
//        archiveMap.put("ajh",archive.getAjh());
        archiveMap.put("nd", archive.getNd());
        String room = archive.getRoomId();
        String carbinet = archive.getCabinetSno();
        Integer side = archive.getSideId();
        Integer cell = archive.getCellId();
        Integer box = archive.getBoxId();

        String ajhs = archiveService.getAjhs(room, carbinet, side, cell, box);
        archiveMap.put("ajhs", ajhs);
        renderJson(archiveMap);
    }


    /**
     * 获取档案的不动产登记proid
     */
    public void materialProid() {
        Archive archive = archiveService.getArchive(modelName, djDaId);
        try {
            String proid = archive.getProId();
            if (proid != null) {
                renderJson(proid);
            } else {
                renderJson("null");
            }
        } catch (Exception e) {
            renderJson("null");
        }
    }

    /**
     * 查询
     */
    public void search() {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        if (ajh != null) {
            criterions.add(Restrictions.eq("ajh", ajh));
        }
        if (!mlh.equals("")) {
            criterions.add(Restrictions.eq("mlh", mlh));
        }
        if (!tm.equals("")) {
            criterions.add(Restrictions.like("tm", tm));
        }
        Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, start, limit);
        renderJson(page);
    }

    /**
     * 原文展示
     */
    public String viewOg() {
        if (StringUtils.isBlank(ownerId) || ownerId == null) {
            return null;
        }

        String sXmlDoc = "";
        if (modelName.contains("_jn")) {
            Document document = archiveService.getDocument(modelName, ownerId);
            if (document == null) {
                return null;
            }

            sXmlDoc = "<Document  id=\"" + document.getId() + "\" name=\"" + document.getTm() + "\" yh=\"" + document.getYh() + "\">";
            List<Original> originals = originalService.getOriginals(document.getId());
            if (originals == null) {
                Archive archive = archiveService.getSimpleArchive(document.getArchiveId());
                if (archive != null) {
                    originals = originalService.getOriginals(archive.getId());
                    if (originals != null && originals.size() == 1) {
                        Original original = originals.get(0);
                        sXmlDoc = sXmlDoc + "<Original id=\"" + original.getId() + "\" name=\"" + original.getName() + "\"></Original>";
                    }
                }
            } else {
                for (Original original : originals) {
                    sXmlDoc = sXmlDoc + "<Original id=\"" + original.getId() + "\" name=\"" + original.getName() + "\"></Original>";
                }
            }

            sXmlDoc = sXmlDoc + "</Document>";
        } else {
            Archive archive = archiveService.getArchive(modelName, ownerId);
            if (archive == null) {
                return null;
            }

            sXmlDoc = "<Archive  id=\"" + archive.getId() + "\">";

            List<Original> originals = originalService.getOriginals(archive.getId());
            if (originals != null) {
                for (Original original : originals) {
                    sXmlDoc = sXmlDoc + "<Original id=\"" + original.getId() + "\" name=\"" + original.getName() + "\"></Original>";
                }
            }

            List<Document> documentList = archiveService.getArchiveDocuments(archive);
            if (documentList != null) {
                for (Document document : documentList) {
                    sXmlDoc = sXmlDoc + "<Document id=\"" + document.getTm() + "\" name=\"" + document.getTm() + "\" yh=\"" + document.getYh() + "\">";

                    originals = originalService.getOriginals(document.getId());
                    if (originals != null) {
                        for (Original original : originals) {
                            sXmlDoc = sXmlDoc + "<Original id=\"" + original.getId() + "\" name=\"" + original.getName() + "\"></Original>";
                        }
                    }

                    sXmlDoc = sXmlDoc + "</Document>";
                }
            }

            sXmlDoc = sXmlDoc + "</Archive>";
        }

        renderJson(sXmlDoc);
        return "viewOg";
    }

    /**
     * 获取第一个ModelName名称
     */
    public void getFirstModelName() {
        List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
        for (Map item : listTree) {
            List<Map<String, Object>> childItem = (List<Map<String, Object>>) item.get("children");
            for (Map child : childItem) {
                modelName = child.get("name").toString();
                renderJson(modelName);
                return;
            }
        }
    }

    /**
     * 档案打包
     */
    public void packageArchive() {
        List<String> mlhs = new ArrayList<String>();
        List ajhs = new ArrayList();
        for (int i = 0; i < archiveIds.length; i++) {
            Archive archive = archiveService.getArchive(modelName, archiveIds[i]);
            mlhs.add(archive.getMlh());
            ajhs.add(archive.getAjh());
        }
        boolean flag = true;
        String firstMlh = mlhs.get(0);
        for (String mlh : mlhs) {
            if (!mlh.equals(firstMlh)) {
                flag = false;
            }
        }
        Collections.sort(ajhs);
        Map map = new HashMap();
        map.put("mlh", firstMlh);
        map.put("firstAjh", ajhs.get(0));
        map.put("lastAjh", ajhs.get(ajhs.size() - 1));
        map.put("size", ajhs.size());
        if (flag) {
            map.put("success", "true");
        } else {
            map.put("success", "false");
        }

        renderJson(map);
    }

    /**
     * 根据案卷号设置盒号，格号，柜号递增
     *
     * @param archive 需要递增的案卷
     * @return
     */
    private Archive changeArchive(Archive archive) {
        //获取最大柜号
        Integer count = archiveService.getArchivePosition();
        int cell;
        int box;
        if (count == null) {
            count = 1;
        }
        //最大柜号的最大格号
        cell = archiveService.getMaxCellId(count);
        //最大柜号的最大格中的最大盒号
        box = archiveService.getMaxBox(cell, count);
        //最大柜号的最大格中的最大盒号中是否存满
        String cabinetSno = archive.getCabinetSno();
        Integer cellId = archive.getCellId();
        Integer boxId = archive.getBoxId();
        boolean lab = archiveService.isBoxFull(box, cell, count);
        //如果新归档的柜号小于最大的柜号，则从最大柜号中续编下去
        if (cabinetSno == null || Integer.valueOf(cabinetSno) <= count) {
            //新归档档案格号小于最大柜号中最大格号
            if (cellId == null || cellId <= cell || cellId > 30) {
                //新归档档案盒号小于最大柜号中最大格号的最大盒号
                if (boxId == null || boxId <= box || boxId > 15) {
                    //最大盒号未满，则直接放入
                    if (!lab) {
                        archive.setCabinetSno(count + "");
                        archive.setCellId(cell);
                        archive.setBoxId(box);
                    } else {
                        //最大盒号放满，判断该格是否放满
                        if (box == 12 && lab) {//最大格放满
                            //最大格放满，判断最大柜是否放满
                            if (cell == 30) {//最大柜放满
                                archive.setCellId(1);
                                archive.setCabinetSno(count + 1 + "");
                            }
                            if (cell < 30) {//最大柜未放满
                                archive.setCabinetSno(count + "");
                                archive.setCellId(cell + 1);
                            }
                            archive.setBoxId(1);
                        }
                        if (box < 12 && lab) {//最大格未放满
                            archive.setCellId(cell);
                            archive.setCabinetSno(count + "");
                            archive.setBoxId(box + 1);
                        }
                    }
                }
            }
        }
        return archive;
    }

    /**
     * 归档是向案卷内写入归档人及归档人id
     */
    private Archive setGdrAndGdrId(Archive archive) {
        archive.setGdr(SessionUtil.getCurrentUser().getUsername());
        archive.setGdrId(SessionUtil.getCurrentUserId());
        if (archive.getGdsj() == null) {
            archive.setGdsj(new Date());
        }
        return archive;
    }

    /**
     * 自动组盒根据案卷号范围查询案卷id
     */
    public void getPakageArchiveId() {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        List<Criterion> criterions1 = this.createCriterions(criterions);
        Page<Archive> page = this.searchEntity(criterions1, null);
        List<Archive> archives = page.getItems();
        List<String> ids = new ArrayList<String>();
        for (Archive archive : archives) {
            ids.add(archive.getId());
        }
        renderJson(ids);
    }

    /**
     * 归档时自动生成档号13位
     *
     * @param archive
     * @return
     */
    public Archive createDhByArchive(Archive archive) {
        String dwjc = null;
        String nd = archive.getNd();
        String modelName = archive.getModelName();
        if (nd == null) {
            DateFormat df = new SimpleDateFormat("yyyy");
            nd = df.format(new Date());
        }
        try {
            String oraganNo = null;
            List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (pfOrganVoList != null && pfOrganVoList.size() > 0) {
                PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                oraganNo = pfOrganVo.getOraganNo();
            }
            String dwdm = oraganNo;
            if (dwdm != null) {
                List<Item> items = this.dictService.getItems("dwjc");
                for (Item item : items) {
                    String value = item.getValue();
                    if (value.equals(dwdm)) {
                        dwjc = item.getName();
                        break;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(nd).append(dwjc);
                buffer.append(modelName.toUpperCase());
                String newDh = buffer.toString();
                Integer ajh = archive.getAjh();
                int length = ajh.toString().length();
                for (int i = newDh.length(); i < 13 - length; i++) {
                    buffer.append("0");
                }
                buffer.append(ajh);
                newDh = buffer.toString();
                archive.setDh(newDh);
            } else {
                logger.error("找不到oraganNo");
            }
        } catch (Exception e) {
            logger.error("dwjc的字典项不存在", e);
        }
        return archive;
    }

    /**
     * 根据业务名获取它的所有的目录号
     */
    public void queryMlhByModelName() {
        List<String> mlhList = ajhRangeService.getMlhByModelName(modelName);
        Map map = new HashMap();
        map.put("list", mlhList);
        renderJson(map);
    }

    /**
     * 获取列表信息
     */
    public void doList() {
        if (ids == null) {
            return;
        }

        String id = getId();
        if (ownerModelName == null || StringUtils.isBlank(ownerModelName)) {
            return;
        }

        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (ownerModelName.contains("_jn") || ownerModelName.equals("document")) {
            Map<String, Object> docMap = getDocumentList(id);
            renderJson(docMap);
        } else {
            Map<String, Object> archiveMap = getArchiveList(id);
            renderJson(archiveMap);
        }
    }

    /**
     * 获取卷内访问列表
     *
     * @param id
     * @return
     */
    private Map<String, Object> getDocumentList(String id) {
        if (id == null || StringUtils.isBlank(id)) {
            return null;
        }

        Document document = archiveService.getSimpleDocument(id);
        if (document == null) {
            return null;
        }

        Map<String, Object> docMap = new HashMap<String, Object>();
        /**
         * 添加原文的list
         */
        List<Original> originals = originalService.getOriginals(document.getId());
        if (originals != null && originals.size() > 0) {
            List<Map<String, Object>> ogList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < originals.size(); i++) {
                Map<String, Object> ogMap = new HashMap<String, Object>();
                Original original = originals.get(i);
                String sFileName = original.getName();
                String sFileType = sFileName.substring(sFileName.indexOf(".") + 1);
                if (sFileType.toUpperCase().equals("JPG") || sFileType.toUpperCase().equals("BMP") || sFileType.toUpperCase().equals("PNG")) {
                    ogMap.put("isImage", true);
                } else {
                    ogMap.put("isDoc", true);
                }

                ogMap.put("icon", sFileType + ".gif");
                ogMap.put("id", original.getId());
                ogMap.put("name", sFileName.trim());
                ogMap.put("parentId", document.getId());
                ogMap.put("scope", 0);
                ogMap.put("size", original.getFileSize());
                ogMap.put("type", 1);
                ogMap.put("updateTime", original.getUpdateTime());

                ogList.add(ogMap);
            }

            docMap.put("items", ogList);
        } else {
            docMap.put("items", null);
        }

        Map<String, Object> docNode = new HashMap<String, Object>();
        docNode.put("childCount", originals.size());
        docNode.put("icon", "folder.gif");
        docNode.put("id", document.getId());
        docNode.put("name", document.getTm().trim());
        docNode.put("modelName", document.getModelName());
        docNode.put("parentId", archiveService.getSimpleArchive(document.getArchiveId()).getId());
        docNode.put("scope", 0);
        docNode.put("type", 0);
        docNode.put("pageCount", (document.getYs() == null || StringUtils.isBlank(document.getYs().toString())) ? 1 : document.getYs());

        docMap.put("node", docNode);
        docMap.put("total", originals.size());

        return docMap;
    }

    /**
     * 获取卷内的List
     *
     * @param id
     * @return
     */
    private Map<String, Object> getArchiveList(String id) {
        if (id == null || StringUtils.isBlank(id)) {
            return null;
        }

        Archive archive = archiveService.getSimpleArchive(id);
        if (archive == null) {
            return null;
        }

        Map<String, Object> archiveMap = new HashMap<String, Object>();
        List<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>();
        /**
         * 添加卷内的信息到list中
         */
        List<Document> documentList = archiveService.getArchiveDocuments(archive.getModelName(), archive.getId());
        if (documentList != null && documentList.size() > 0) {
            for (int i = 0; i < documentList.size(); i++) {
                Map<String, Object> docMap = new HashMap<String, Object>();
                Document document = documentList.get(i);
                List<Original> originals = originalService.getOriginals(document.getId());
                docMap.put("childCount", originals.size());
                docMap.put("icon", "folder.gif");
                docMap.put("id", document.getId());
                docMap.put("name", document.getTm().trim());
                docMap.put("modelName", document.getModelName());
                docMap.put("parentId", archiveService.getSimpleArchive(document.getArchiveId()).getId());
                docMap.put("scope", 0);
                docMap.put("type", 0);
                docMap.put("pageCount", (document.getYs() == null || StringUtils.isBlank(document.getYs().toString())) ? 1 : document.getYs());

                itemList.add(docMap);
            }
        }

        /**
         * 添加原文的信息到List中
         */
        List<Original> originals = originalService.getOriginals(archive.getId());
        if (originals != null && originals.size() > 0) {
            for (int i = 0; i < originals.size(); i++) {
                Map<String, Object> ogMap = new HashMap<String, Object>();
                Original original = originals.get(i);
                String sFileName = original.getName();
                String sFileType = sFileName.substring(sFileName.indexOf(".") + 1);
                if (sFileType.toUpperCase().equals("JPG") || sFileType.toUpperCase().equals("BMP") || sFileType.toUpperCase().equals("PNG")) {
                    ogMap.put("isImage", true);
                } else {
                    ogMap.put("isDoc", true);
                }

                ogMap.put("icon", sFileType + ".gif");
                ogMap.put("id", original.getId());
                ogMap.put("name", sFileName.trim());
                ogMap.put("parentId", archive.getId());
                ogMap.put("scope", 0);
                ogMap.put("size", original.getFileSize());
                ogMap.put("type", 1);
                ogMap.put("updateTime", original.getUpdateTime());
                itemList.add(ogMap);
            }
        }

        archiveMap.put("items", itemList);

        ////添加node信息
        Map<String, Object> nodeMap = new HashMap<String, Object>();
        nodeMap.put("childCount", documentList.size() + originals.size());
        nodeMap.put("icon", "folder.gif");
        nodeMap.put("id", archive.getId());
        nodeMap.put("name", StringUtils.isBlank(archive.getTm()) ? "所有原文" : archive.getTm().trim());
        nodeMap.put("modelName", archive.getModelName());
        nodeMap.put("parentId", -1);
        nodeMap.put("scope", 0);
        nodeMap.put("type", 0);
        nodeMap.put("pageCount", (archive.getYs() == null || StringUtils.isBlank(archive.getYs().toString())) ? 1 : archive.getYs());
        archiveMap.put("node", nodeMap);

        ////添加total信息
        archiveMap.put("total", documentList.size() + originals.size());

        return archiveMap;
    }

    /**
     * 查看档案流程
     */
    public void showFlow() {
        String flowValue = null;
        try {
            flowValue = dictService.getItemValue(Permission.FLOW_DICT, modelName);
            Archive archive = archiveService.getArchive(modelName, djDaId);
            String proid = archive.getProId();
            if (proid != null && StringUtils.isNotBlank(proid)) {
                flowValue = flowValue + proid;
            }
        } catch (Exception e) {
            logger.error("查看档案流程失败", e);
            renderJson("查看档案流程失败");
        }
        renderJson(flowValue);
    }

    /**
     * 组盒保存更新案卷的盒号
     */
    public void pakageAndSaveBox() {
        if (archiveService.isExistBoxId(boxId, mlh, modelName)) {
            renderJson("操作失败！盒号" + boxId + "已被占用！");
        } else {
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            List<Criterion> criterions1 = this.createCriterions(criterions);
            Page<Archive> page = this.searchEntity(criterions1, null);
            List<Archive> archives = page.getItems();
            StringBuilder sb = new StringBuilder();
            for (Archive archive : archives) {
                if (archive.getBoxId() != null) {
                    renderJson("操作失败！案卷号为" + archive.getAjh() + "的案卷已经装盒！");
                    return;
                }
                sb.append("\'").append(archive.getId()).append("\'").append(",");
            }
            String sbs = sb.toString();
            String idStr = sbs.substring(0, sbs.length() - 1);
            String hql = "update t_archive t set t.box_id = ? where t.id in (" + idStr + ")";
            archiveService.upDateArchiveByHql(hql, boxId);
            renderJson("组盒成功！");
        }
    }

    /**
     * 撤销组盒
     */
    public void removePakage() {
        if (!archiveService.isExistBoxId(boxId, mlh, modelName)) {
            renderJson("操作失败！盒号" + boxId + "不存在！");
        } else {
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            List<Criterion> criterions1 = this.createCriterions(criterions);
            Page<Archive> page = this.searchEntity(criterions1, null);
            List<Archive> archives = page.getItems();
            StringBuilder sb = new StringBuilder();
            for (Archive archive : archives) {
                if (archive.getState() == 1) {
                    renderJson("操作失败！已归档的档案不能撤销组盒！");
                    return;
                }
                if (archive.getBoxId() != boxId) {
                    renderJson("操作失败！案卷号为" + archive.getAjh() + "的案卷不在此盒号内！");
                    return;
                }
                sb.append("\'").append(archive.getId()).append("\'").append(",");
            }
            String sbs = sb.toString();
            String idStr = sbs.substring(0, sbs.length() - 1);
            String hql = "update t_archive t set t.box_id = null where t.id in (" + idStr + ")";
            archiveService.upDateArchiveByHql(hql);
            renderJson("撤销组盒成功！");
        }
    }
}
