package com.gtis.archive.service.impl;

import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.support.hibernate.HibernateTemplate;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 13-4-17
 * Time: 下午2:47
 * To change this template use File | Settings | File Templates.
 */
public class RecordAjhRangeServiceImpl extends HibernateTemplate<RecordAjhRange,String>  implements RecordAjhRangeService {

    private boolean dwdmEnable = false;

    public void setDwdmEnable(boolean dwdmEnable) {
        this.dwdmEnable = dwdmEnable;
    }

    /**
     * 根据目录号获取可用的
     * @param mlh
     * @param modelName
     * @return
     */
    public RecordAjhRange getAvailable(String mlh, String modelName,String dwdm) {
        if(dwdmEnable){
            if(StringUtils.isBlank(modelName)||StringUtils.isBlank(dwdm)) return null;
            Criteria criteria = createCriteria();
            if(StringUtils.isNotBlank(mlh)){
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm), Restrictions.eq("mlh", mlh));
            }else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm));
            }
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0);
        }else {
            if(StringUtils.isBlank(modelName)) return null;
            Criteria criteria = createCriteria();
            if(StringUtils.isNotBlank(mlh)){
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("mlh", mlh));
            }else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName));
            }
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0);

        }

        return null;
    }

    @Override
    public RecordAjhRange getRecordAjhRange(String mlh, String modelName, String dwdm, String bgqx) {
        if(dwdmEnable){
            if(StringUtils.isBlank(modelName)||StringUtils.isBlank(dwdm)) return null;
            Criteria criteria = createCriteria();
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm), Restrictions.eq("mlh", mlh),Restrictions.eq("bgqx",bgqx));
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0);
        }else {
            if(StringUtils.isBlank(modelName)) return null;
            Criteria criteria = createCriteria();
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("mlh", mlh),Restrictions.eq("bgqx",bgqx));
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0);

        }
        return null;
    }

    @Transactional
    public void remove(String id) {
        delete(id);
    }

    @Override
    public String removeHasUsed(String mlh, String modelName, String dwdm, String bgqx, int ajh) {
        if(dwdmEnable){
            if(StringUtils.isBlank(modelName)||StringUtils.isBlank(dwdm)) return null;
            Criteria criteria = createCriteria();
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm), Restrictions.eq("mlh", mlh),Restrictions.eq("bgqx",bgqx),Restrictions.eq("ajh",ajh));
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0).getId();
        }else {
            if(StringUtils.isBlank(modelName)) return null;
            Criteria criteria = createCriteria();
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("mlh", mlh),Restrictions.eq("bgqx",bgqx),Restrictions.eq("ajh",ajh));
            List<RecordAjhRange> list=criteria.addOrder(Order.asc("mlh")).addOrder(Order.asc("ajh")).list();
            if(list!=null&&list.size()>0)
                return list.get(0).getId();

        }
        return null;
    }

    @Transactional
    public RecordAjhRange saveRecordAjh(RecordAjhRange recordAjhRange) {
        save(recordAjhRange);
        return recordAjhRange;
    }
}
