package com.gtis.archive.entity;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * <p>
 * 权限表
 * Generated 2010-12-08 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_permission")
public class Permission implements Serializable {
    private static final long serialVersionUID = -2545246557701589198L;
    public static final String OPERATION_DICT = "operationPerm";
    public static final String SYS_FUNCTION_DICT = "sysPerm";
    public static final String VIEW_PERMISSION = "view";
    public static final String LOANTYPE_DICT = "loanType";
    public static final String FLOW_DICT = "flow";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 资源序号
     */
    @Column(length = 100, nullable = false)
    private String resourceId;

    /**
     * 角色序号
     */
    @Column(length = 100, nullable = false)
    private String roleId;

    /**
     * 操作名
     */
    @Column(length = 100, nullable = false)
    private String operation;

    public Permission() {
    }

    public Permission(String resourceId, String roleId, String operation) {
        this.resourceId = resourceId;
        this.roleId = roleId;
        this.operation = operation;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Permission))
            return false;
        Permission p = (Permission) obj;
        return resourceId != null && resourceId.equals(p.getResourceId()) &&
                operation != null && operation.equals(p.getOperation()) &&
                roleId != null && roleId.equals(p.getRoleId());
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + resourceId.hashCode();
        hash = hash * 31 + operation.hashCode();
        hash = hash * 31 + roleId.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "[" + resourceId + "," + operation + "," + roleId + "]";
    }
}
