package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 原文关系表
 * <p/>
 * Generated 2010-08-13 13:17:16 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_original_rel")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class OriginalRel {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 所有者序号
     */
    @Column(length = 32)
    private String ownerId;

    /**
     * 所有者模型名
     */
    @Column(length = 10)
    private String ownerModelName;

    /**
     * 项目Id
     */
    @Column(length = 100)
    private String relationId;

    /**
     * 原文Id
     */
    @Column(length = 32)
    private String originalId;

    @ManyToOne
    @JoinColumn(name = "originalId", insertable = false, updatable = false)
    private Original original;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public Original getOriginal() {
        return original;
    }

    public void setOriginal(Original original) {
        this.original = original;
    }
}