package com.gtis.archive.core;

import com.gtis.archive.Constants;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.text.ParseException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-3
 */
public class Field {
    private String name;
    private String title;
    private String remark;
    private Type type;
    private Integer length;
    private Boolean nullable;
    private String valueDict;
    private String validation;
    private String defaultValue;

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getNullable() {
        return nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getValidation() {
        return validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public String getValueDict() {
        return valueDict;
    }

    public void setValueDict(String valueDict) {
        this.valueDict = valueDict;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Field && name != null && name.equals(((Field) obj).getName());
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Object getValue(String value) {
        Object v = null;
        try {
            switch (getType()) {
                case TEXT:
                    v = value;
                    break;
                case NUMBER:
                    if(getLength() == null || getLength() <= 10){
                        v = Integer.valueOf(value);
                    }
                    else {
                        v = Long.valueOf(value);
                    }
                    break;
                case BOOLEAN:
                    v = Boolean.valueOf(value);
                    break;
                case DATE:
                    v = Constants.DATE_FORMAT.parse(value);
                    break;
                case DATETIME:
                    v = Constants.DATETIME_FORMAT.parse(value);
                    break;
                case FLOAT:
                    v = Double.valueOf(value);
                    break;
            }
        } catch (ParseException ignored) {
        }
        return v;
    }

    public enum Type {
        TEXT, NUMBER, FLOAT, DATE, DATETIME, BOOLEAN
    }
}
