package com.gtis.archive.web;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.SecurityService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

public class ReportAction implements Action {

    @Autowired
    protected DictService dictService;
    @Autowired
    private SecurityService securityService;

    private String type;

    private String dwdm;

    private  String userName;

    /**
     * 系统权限列表
     */
    private Map<String, Boolean> sysPerms;

    public String execute() throws Exception {
        dwdm = SessionUtil.getCurrentUser().getRegionCode();
        userName = SessionUtil.getCurrentUser().getUsername();
        return Action.SUCCESS;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Boolean> getSysPerms() {
        sysPerms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                sysPerms.put(item.getName(), true);
        }
        return sysPerms;
    }
}
