package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.entity.OriginalRel;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-27
 */
@InterceptorRefs({@InterceptorRef(value = "fileUpload", params = {"maximumSize", "5368709120"}), @InterceptorRef(value = "defaultStack")})
public class OgAction extends BaseModelAction<Original> {
    private static final Logger logger = LoggerFactory.getLogger(OgAction.class);

    private enum FileType {
        PDF, ZIP, TXT, XLS;

        public static boolean enqualsType(String type) {
            for (FileType fileType : FileType.values()) {
                if (fileType.name().equalsIgnoreCase(type)) {
                    return true;
                }
            }
            return false;
        }
    }

    @Autowired
    private OriginalService originalService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalPermissionService originalPermissionService;
    @Autowired
    private SysUserService sysUserService;
    /**
     * 所有者id
     */
    private String ownerId;
    /**
     * 是否预览模式
     */
    private boolean preview;
    /**
     * 上传的文件
     */
    private File filedata;
    /**
     * 上传的文件名
     */
    private String filename;

    /**上传的文件大小
     *
     */
    private String fileSize;

    /**
     * 上传时间
     */
    private Date  updateTime;
    /**
     * 收件时间
     */
    private Date receiveTime;
    /**
     * 权限
     */
    private OriginalPermission op;
    /**
     * 下载,查看还是打印
     */
    private String action = "download";

    /**
     * 相对目录（依据根目录后的子目录路径）名称
     */
    private String dirName;

    /**
     * 创建的文件夹名称
     */
    private String folderName;

    private boolean folder = false;

    /**
     * 文件夹原始名称
     */
    private String fromName;

    /**
     * 文件夹改变的名称
     */
    private String toName;

    /**
     * 原文的id
     */
    private String fid;

    private String ownerModelName;

    private static File uploadFile = null;

    private int uploadingStatus = 0;

    private String documentId;

    /**
     * 档案关联类型
     */
    private String linktype;

    /**
     * originalIds
     */
    private String[] originalIds;

    /**
     * 所属者的模型名
     */
    private String ownerModerName;

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) throws UnsupportedEncodingException {
        this.dirName = URLDecoder.decode(dirName, "UTF-8");
    }

    public String getFolderName() {
        return folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public boolean isFolder() {
        return folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public void setNid(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getFromName() {
        return fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getToName() {
        return toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setFiledata(File filedata) {
        this.filedata = filedata;
    }

    public void setFile(File filedata) {
        this.filedata = filedata;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileFileName(String filename) {
        this.filename = filename;
    }

    public void setOp(OriginalPermission op) {
        this.op = op;
    }

    public OriginalPermission getOp() {
        return op;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public static File getUploadFile() {
        return uploadFile;
    }

    public static void setUploadFile(File uploadFile) {
        OgAction.uploadFile = uploadFile;
    }

    public int getUploadingStatus() {
        return uploadingStatus;
    }

    public void setUploadingStatus(int uploadingStatus) {
        this.uploadingStatus = uploadingStatus;
    }

    public String getFid() {
        return fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getLinktype() {
        return linktype;
    }

    public void setLinktype(String linktype) {
        this.linktype = linktype;
    }

    public String[] getOriginalIds() {
        return originalIds;
    }

    public void setOriginalIds(String[] originalIds) {
        this.originalIds = originalIds;
    }

    public String getOwnerModerName() {
        return ownerModerName;
    }

    public void setOwnerModerName(String ownerModerName) {
        this.ownerModerName = ownerModerName;
    }

    public String getFilename() {
        return filename;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String remove() throws Exception {
        originalService.removeOriginal(ids);
        return null;
    }

    public void delete() throws Exception {
        if (fid == null) {
            return;
        }
        originalService.removeOriginal(fid);
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public void setDocumentId(String documentId){
        this.documentId = documentId;
    }

    public String getDocumentId(){
        return documentId;
    }


    /**
     * 上传flash检查重名用
     *
     * @return 重名列表
     */
    public String check() {
        Struts2Utils.renderHtml("{}");
        return null;
    }

    public String get() throws Exception {
        try {
            String id = getId();
            if (!originalPermissionService.hasOriginalPermission(id) && !preview)
                return null;
            HttpServletResponse response = ServletActionContext.getResponse();
            Original original = originalService.getOriginal(id);
            if (original.isImage())
                response.setContentType("image/" + original.getExtension());
            else if (original.isXOffice())
                response.setContentType("application/vnd.openxmlformats");
            else
                response.setContentType("application/octet-stream");

            //保存图片宽高比
            saveKGB(original, originalService.getOriginalFile(id, action));

            response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
            sendFile(originalService.getOriginalFile(id, action));
        } catch (Throwable e) {
            logger.error("Get error", e);
        }
        return null;
    }

    public String down() throws Exception {
        try {
            if (fid == null) {
                return null;
            }

            HttpServletResponse response = ServletActionContext.getResponse();
            Original original = originalService.getOriginal(fid);
            if (original.isImage())
                response.setContentType("image/" + original.getExtension());
            else if (original.isXOffice())
                response.setContentType("application/vnd.openxmlformats");
            else
                response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
            sendFile(originalService.getOriginalFile(fid, action));
        } catch (Throwable e) {
            logger.error("Get error", e);
        }
        return null;
    }

    /**
     * 多文件打包下载
     *
     * @return
     */
    public String getBatch() throws Exception {
        byte[] buffer = new byte[1024];
        String fileName = System.currentTimeMillis() + ".zip";
        String mapKey = "originalRoot";
        Map<String, String> map = EnvHolder.getAppEnv().getProps();
        for (String key : map.keySet()) {
            if (key.contains("originalRoot") && EnvHolder.getAppEnv().getProps().get(key) != null) {
                mapKey = key;
                break;
            }
        }
        String zipPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString())
                + "/tempZip/" + fileName;
        String zipRootPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString())
                + "/tempZip/";
        File tempFile = new File(zipRootPath);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipPath));
        for (String id : ids[0].split(",")) {
            File file = originalService.getOriginalFile(id, action);
            FileInputStream fis = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            int len;
            while ((len = fis.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
            zipOutputStream.closeEntry();
            fis.close();
        }
        zipOutputStream.close();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(fileName.getBytes("gbk"), "iso8859-1") + "\"");
        sendFile(new File(zipPath));
        File file = new File(zipPath);
        if (file.exists()) {
            file.delete();
        }
        return null;
    }

    /**
     * 打包下载所有原文
     *
     * @return
     * @throws Exception
     */
    public String getBatchAll() throws Exception {
        byte[] buffer = new byte[1024];
        String fileName = System.currentTimeMillis() + ".zip";
        String mapKey = "originalRoot";
        Map<String, String> map = EnvHolder.getAppEnv().getProps();
        for (String key : map.keySet()) {
            if (key.contains("originalRoot") && EnvHolder.getAppEnv().getProps().get(key) != null) {
                mapKey = key;
                break;
            }
        }
        String zipPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString())
                + "/tempZip/" + fileName;
        String zipRootPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString())
                + "/tempZip/";
        File tempFile = new File(zipRootPath);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipPath));
        List<Original> lists = originalService.getOriginals(ownerId);
        for (Original original : lists) {
            File file = originalService.getOriginalFile(original.getId(), action);
            FileInputStream fis = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            int len;
            while ((len = fis.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
            zipOutputStream.closeEntry();
            fis.close();
        }
        zipOutputStream.close();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(fileName.getBytes("gbk"), "iso8859-1") + "\"");
        sendFile(new File(zipPath));
        File file = new File(zipPath);
        if (file.exists()) {
            file.delete();
        }
        return null;
    }

    public void view() throws Exception{
        for (String id : originalIds) {
            File file = originalService.getOriginalFile(id, "view");
        }
    }

    public String preview() throws Exception {
        List<Original> ogs = getEntities();
        Document doc = DocumentHelper.createDocument();
        Element files = doc.addElement("files");
        String id = getId();
        String baseUrl = "${.vars['archive.url']}/og!get.action;jsessionid=" + ServletActionContext.getRequest().getSession().getId() + "?preview=true&id=";
        for (Original og : ogs) {
            String url = EnvHolder.getAppEnv().getExpr(baseUrl + og.getId());
            Element file = files.addElement("file").addAttribute("name", og.getName()).addAttribute("url", url);
            if (og.getId().equals(id))
                file.addAttribute("iscurrent", "true");
        }
        Struts2Utils.renderXml(doc.asXML());
        return null;
    }

    public String upload() {
        Map<String, Object> map = new HashMap<String, Object>();
        // boolean flag = false ;
        try {
            synchronized (filedata) {
                if (filename != null) {
                    setUploadFile(filedata);
                    Original original = new Original();
                    if(documentId != null){
                        if(documentId != ownerId){
                            ownerId = documentId;
                        }
                    }
                    original.setOwnerId(ownerId);
                    original.setName(URLDecoder.decode(filename, "UTF-8"));

                    if ("list".equals(EnvHolder.getAppEnv().get("view.original"))) {
                        originalService.saveOriginalFile(original, filedata, ownerModelName, false);
                        original = originalService.saveOriginal(original);
                    } else if ("acronym".equals(EnvHolder.getAppEnv().get("view.original"))) {
                        originalService.saveOriginalFile(original, filedata, ownerModelName, false, dirName);
                        original = originalService.saveOriginal(original);
                    } else if ("tree".equals(EnvHolder.getAppEnv().get("view.original"))) {
                        originalService.saveOriginalFile(original, filedata, ownerModelName, false);
                        original = originalService.saveOriginal(original);
                    }

                    ////保存原文关系信息
                    originalService.saveOriginalRel(original, original.getId());
                    map.put("type", 0);
                } else {
                    throw new RuntimeException("获取上传文件名异常，请稍后再试");
                }
            }
        } catch (Exception e) {
            map.put("type", 5);
            logger.error("upload error", e);
        }
        if (filedata != null)
            filedata.delete();
        renderJson(map);
        return null;
    }

    public String uploadFileState() {
        Map<String, Object> map = new HashMap<String, Object>();

        if (getUploadFile() != null || uploadingStatus == 1) {
            map.put("uploadComplete", originalService.getUploadState(getUploadFile()));
        } else if (getUploadFile() == null) {
            map.put("uploadComplete", "error");
        }

        setUploadFile(null);
        return renderJson(map);
    }

    public String thumb() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        Original original = originalService.getOriginal(getId());
        response.setContentType("image/" + original.getExtension());
        File file = originalService.getOriginalThumbFile(original.getId());
        if (file != null && file.exists()) {
            sendFile(file);
        } else {
            response.sendRedirect("img/no-thumb.gif");
        }
        return null;
    }

    public String print() throws Exception {
        return "print";
    }

    public String listPermission() {
        List<OriginalPermission> ops = originalPermissionService.getOriginalPermissions(getId());
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("items", ops);
        Struts2Utils.renderJson(map);
        return null;
    }

    public String listUsers() {
        List<PfUserVo> list = sysUserService.getAllUsers();
        List<Map<String, Object>> users = new ArrayList<Map<String, Object>>(list.size());
        for (PfUserVo user : list) {
            if (StringUtils.isNotBlank(query) && !user.getUserName().contains(query))
                continue;
            Map<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("userId", user.getUserId());
            map.put("userName", user.getUserName());
            users.add(map);
        }
        Struts2Utils.renderJson(users);
        return null;
    }

    public String addPermission() {
        originalPermissionService.saveOriginalPermission(op);
        return renderSuccess();
    }

    public String removePermission() {
        for (String id : ids) {
            originalPermissionService.removeOriginalPermission(id);
        }
        return renderSuccess();
    }

    public String link() {
        String id = getId();
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        try {
            File root = ResourceUtils.getFile(EnvHolder.getAppEnv().get("myOriginalPath"));
            File path = ResourceUtils.getFile(root.getAbsolutePath() + "/" + ("root".equals(id) ? "" : id));
            for (File f : path.listFiles()) {
                Map<Object, Serializable> map = new HashMap<Object, Serializable>();
                map.put("id", f.getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
                map.put("text", f.getName());
                map.put("leaf", !f.isDirectory());
                map.put("checked", false);
                list.add(map);
            }
        } catch (FileNotFoundException e) {
            logger.error("错误,linkOriginalPath没有设置,无法关联文件", e.getMessage());
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    public String saveLink() {
        List<Original> originals = originalService.getOriginals(ownerId);
        Set<String> ogNames = new HashSet<String>();
        for (Original og : originalService.getOriginals(ownerId)) {
            ogNames.add(og.getPath());
        }
        try {
            File root = ResourceUtils.getFile(EnvHolder.getAppEnv().get("myOriginalPath"));
            for (String id : ids) {
                File file = new File(root, id);
                if (file.isDirectory())
                    continue;
                String path = "${myOriginalPath}/" + file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
                if (ogNames.contains(path))
                    continue;
                Original original = new Original();
                original.setName(file.getName());
                original.setPath(path);
                original.setFileSize(file.length());
                original.setOwnerId(ownerId);
                originalService.saveOriginal(original);
            }
        } catch (FileNotFoundException ignored) {
        }
        return null;
    }

    @Override
    protected Page<Original> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return originalService.searchOriginal(ownerId, query, start, limit);
    }

    /**
     * 获取所有的原文id
     *
     * @return
     */
    public String allIds() {
        if (StringUtils.isBlank(ownerId)) return null;
        Struts2Utils.renderJson(originalService.getIds(ownerId));
        return null;
    }

    /**
     * 获取缩略图
     *
     * @return
     * @throws Exception
     */
    public String getAcronym() throws Exception {
        try {
            String id = getId();
            HttpServletResponse response = ServletActionContext.getResponse();
            HttpServletRequest request = ServletActionContext.getRequest();
            if (!folder) {
                if (!originalPermissionService.hasOriginalPermission(id) && !preview)
                    return null;
                Original original = originalService.getOriginal(id);
                if (original.isImage()) {
                    response.setContentType("image/" + original.getExtension());
                    response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
                    sendFile(originalService.getOriginalFile(id, action));
                } else if (original.isXOffice() || FileType.enqualsType(original.getExtension())) {
//                    response.setContentType("application/vnd.openxmlformats");
                    response.setContentType("image/gif");
                    sendFile(new File(request.getSession().getServletContext().getRealPath("/") + "/img/icon/big/" + original.getExtension() + ".gif"));
                } else if (!FileType.enqualsType(original.getExtension())) {
                    response.setContentType("image/gif");
                    sendFile(new File(request.getSession().getServletContext().getRealPath("/") + "/img/icon/big/unknow.gif"));
                } else {
                    response.setContentType("application/octet-stream");
                    response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
                    sendFile(originalService.getOriginalFile(id, action));
                }
            } else {
                response.setContentType("image/gif");
                response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"new folder\"");
                sendFile(new File(request.getSession().getServletContext().getRealPath("/") + "/img/icon/big/folder.gif"));
            }
        } catch (Throwable e) {
            logger.error("Get error", e);
        }
        return null;
    }

    /**
     * 获取文件夹下的文件列表信息
     *
     * @return
     */
    public String acronymList() {

        Map result = new HashMap();
        try {
            Set<Map> originals = new HashSet<Map>();
            originals = originalService.getAllAcronymInfo(ownerId, modelName, dirName);
            result.put("items", originals);
        } catch (Exception ex) {
            logger.error("get AcronymInfo error:" + ex.toString());
        }
        renderJson(result);
        logger.info("acronymList" + JSON.toJSONString(result));
        return null;
    }

    /**
     * 创建文件夹
     */
    public void makeDir() {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            originalService.makeDir(dirName, folderName, ownerId, modelName);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "创建文件夹出现了异常，异常信息请查看日志记录！");
            logger.error("create directory with error: " + ex.toString());
        }

        renderJson(result);
    }

    /**
     * 删除文件夹
     */
    public void removeDir() {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            originalService.removeDir(dirName, folderName, ownerId, modelName);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "删除文件夹出现了异常，异常信息请查看日志记录！");
            logger.error("remove directory with error:" + ex.toString());
        }
    }

    /**
     * 重命名文件夹
     */
    public void renameDir() {
        Map result = new HashMap();
        try {
            originalService.renameDir(fromName, toName, ownerId, modelName, dirName);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "重命名出现异常，异常信息请看日志");
            logger.error("rename directory with error:" + ex.toString());
        }
        renderJson(result);
    }

    /**
     * 重命名文件夹下的原文名称
     */
    public void renameDirFile() {
        Map result = new HashMap();
        try {
            originalService.renameOriginal(dirName, fromName, toName, ownerId, modelName, fid);
            result.put("success", true);
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", "重命名出现异常，异常信息请看日志");
            logger.error("rename file with error:" + ex.toString());
        }
    }

    /**
     * 获取文件树结构
     */
    public void getOgTree() {
        renderJson(originalService.getAllOriginalTree(ownerId, modelName));
    }

    /**
     * 下载选择的图片形成PDF
     */
    public void downloadPDF() {
        final HttpServletResponse response = (HttpServletResponse) ActionContext.getContext().get(ServletActionContext.HTTP_RESPONSE);
        response.setContentType("application/pdf");
        try {
            File file = originalService.downloadPDF(idsKey.split(","));
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(file.getName().getBytes("gb2312"), "iso-8859-1"));
            sendFile(file);
        } catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException :" + e.toString());
        } catch (IOException e) {
            logger.error("download PDF with IOException" + e.toString());
        }

    }

    /**
     * 保存图片宽高比
     * @param original
     * @param file
     * @throws Exception
     */
    public void saveKGB(Original original, File file) throws Exception{
        try{
            if(original == null || file == null){
                return;
            }

            BufferedImage bufferedImage = ImageIO.read(file);
            if(bufferedImage == null){
                return;
            }

            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();

            original.setKgb((double)width / height);
            originalService.saveOriginal(original);
        }catch (Exception e){
            logger.error("Get error", e);
        }
    }

    /**
     * 获取图片宽高比
     * @throws Exception
     */
    public void getKGB() throws Exception {
        try {
            String id = getId();
            renderJson(originalService.getKGB(id));
        } catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public String uploadOriginal(){
        return "upload";
    }

    public void getLinkOriginal(){
        try{
            linktype = "1";
            renderJson(getLinkEntityPage());
        }
        catch (Exception e){
            logger.error(e.toString());
        }
    }

    public void getNotLinkOriginal(){
        try{
            linktype = "0";
            renderJson(getLinkEntityPage());
        }
        catch (Exception e){
            logger.error(e.toString());
        }
    }

    /**
     * 将未归档原文添加到待归档原文
     */
    public void addLinkOriginal(){
        try {
            if (originalIds == null || originalIds.length == 0) {
                renderJson("");
            }

            String sMessage = "";
            for (int i = 0; i < originalIds.length; i++){
                Original original = originalService.getOriginal(originalIds[i]);
                original.setLinktype("1");
                originalService.saveOriginal(original);
            }

            renderJson(sMessage);
        } catch (Exception e) {
            logger.error("将未归档原文添加到待归档原文失败：", e.toString());
            renderJson("");
        }
    }

    /**
     * 将待归档原文移除到未归档原文
     */
    public void removeLinkOriginal() {
        try {
            if (originalIds == null || originalIds.length == 0) {
                renderJson("");
            }

            String sMessage = "";
            for (int i = 0; i < originalIds.length; i++) {
                Original original = originalService.getOriginal(originalIds[i]);
                original.setLinktype("0");
                originalService.saveOriginal(original);
            }

            renderJson(sMessage);
        } catch (Exception e) {
            logger.error("将待归档原文移除到未归档原文失败：", e.toString());
            renderJson("");
        }
    }

    /**
     * 删除未归档的原文信息
     */
    public  void deleteLinkOriginal() {
        try {
            if (originalIds == null || originalIds.length == 0) {
                renderJson("");
            }

            String sMessage = "";
            originalService.removeOriginal(originalIds);
            renderJson(sMessage);
        } catch (Exception e) {
            logger.error("删除未归档原文失败：", e.toString());
            renderJson("");
        }
    }

    protected Page<Original> getLinkEntityPage() {
        List<Criterion> criterions = createLinkCriterions(new ArrayList<Criterion>());
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.desc("updateTime"));
        return searchLinkEntity(criterions, orders);
    }

    protected List<Criterion> createLinkCriterions(ArrayList<Criterion> criterions) {
        if (linktype != null && StringUtils.isNotBlank(linktype)) {
            criterions.add(Restrictions.eq("linktype", linktype));
        }
        return super.createCriterions(criterions);
    }

    protected Page<Original> searchLinkEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Original> page = entityService.search("Original", criterions, orders, start, limit);
        return page;
    }

    public void saveOiginal(){
        if(originalIds == null || originalIds.length == 0){
            return;
        }

        try {
            for (int i = 0; i < originalIds.length; i++) {
                Original original = originalService.getOriginal(originalIds[i]);
                original.setOwnerId(ownerId);
                original.setOwnerModelName(ownerModelName);
                original.setLinktype("");
                originalService.saveOriginal(original);
            }
        }catch (Exception ex){
            logger.error("原文挂接档案失败：", ex.toString());
        }
    }

    @Autowired
    private ExtTreeService treeService;

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }


    public void editOriginal(){
        Original original = originalService.getOriginal(fid);
        original.setName(filename);
//        original.setFileSize(Integer.parseInt(fileSize));
        original.setUpdateTime(updateTime);
        original.setReceiveTime(receiveTime);
        try {
            originalService.saveOriginal(original);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据原文关系表获取原文
     */
    @Override
    public void list() {
        if(ownerId != null) {
            List<Original> originals = originalService.getOriginals(ownerId);
            renderJson(new Page<Original>(originals));
            logger.info("原文列表获取模式，获取ownerId为"+ownerId+"的原文列表");
        } else {
            throw new RuntimeException("archive或者document的id为空");
        }
    }
}
