package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class IndexAction implements Action {
    private static final long serialVersionUID = -465202185697219258L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private SecurityService securityService;

    @Autowired
    private SysUserService userService;

    private boolean hideBanner;
    private Boolean isA3d;
    private String id;
    private String modelName;
    private Map<String, Boolean> perms;
    private HashMap<String, Object> a3dFieldsMap;

    private String userName;

    /**
     * 系统权限列表
     */
    private Map<String, Boolean> sysPerms;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Boolean> getSysPerms() {
        return sysPerms;
    }

    public void setSysPerms(Map<String, Boolean> sysPerms) {
        this.sysPerms = sysPerms;
    }

    @Autowired
    protected EntityService entityService;

    public void setHideBanner(boolean hideBanner) {
        this.hideBanner = hideBanner;
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }
    public String getAbl(){
        String currentDwdm=getDwdm();
        try{
            Struts2Utils.renderJson(dictService.getItems(Constants.HUCHA_PREFIX+currentDwdm));
        }catch (Exception ex){
            Struts2Utils.renderJson("NULL");
        }
        return null;
    }

    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Boolean isA3d() {
        return isA3d;
    }

    public Map<String, Boolean> getPerms() {
        return perms;
    }

    public String a3dframe() throws Exception {
        return "a3dframe";
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public HashMap<String, Object> getA3dFieldsMap() {
        return a3dFieldsMap;
    }

    public String execute() throws Exception {
        if (hideBanner) {
            Struts2Utils.getSession().setAttribute("hideBanner", Boolean.TRUE);
        }
        if (AppConfig.getBooleanProperty("archive3d.enable")) {
            isA3d = true;
        }
        perms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                perms.put(item.getName(), true);
        }

        sysPerms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                sysPerms.put(item.getName(), true);
        }
      //  ServletActionContext.getRequest().setAttribute("modelName",modelName);

        userName = SessionUtil.getCurrentUser().getUsername();

        return SUCCESS;
    }

    public String a3d() throws Exception {
        isA3d = true;
        Archive archive = null;
        a3dFieldsMap = new HashMap<String, Object>();
        if (modelName == null) {
            return "a3d";
        } else if ("Archive".equals(modelName)) {
            archive = archiveService.getArchive(modelName, id);
        } else if (modelName.lastIndexOf("_jn") > -1) {
            Document doc = archiveService.getDocument(modelName, id);
            archive = archiveService.getDocumentArchive(doc);
        }
        if (archive != null) {
            a3dFieldsMap.put("archiveid", id);
            a3dFieldsMap.put("ajh", archive.getAjh());
            a3dFieldsMap.put("mlh", archive.getMlh());
            a3dFieldsMap.put("title", archive.getTm());
        }
        return "a3d";
    }


    /**
     * 获取当前用户的欠当
     * @return
     */
    public String exceedLoan(){
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions=new ArrayList<Criterion>();
            criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
            criterions.add(Restrictions.eq("state", 0));

        if(SessionUtil.getCurrentUser().isAdmin()){
                Struts2Utils.renderJson(0);
            return null;
        } else if(EnvHolder.isEnable(Switch.DWDM)){
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",getDwdm())));
        }
        criterions.add(Restrictions.or(Restrictions.isNull("userId"),Restrictions.eq("userId",userInfo.getId())));
        int count=entityService.search(new CriteriaCallback(){
            public Criteria create(Session session) {
                return session.createCriteria(Loan.class).createAlias("archive", "arc");
            }
        },criterions,null,0,-1).getTotalCount();
        Struts2Utils.renderJson(count);
        return null;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    public  String context() {
        return "context";
    }
}
