package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.print.Doc;
import java.lang.reflect.Field;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-20
 */
public class DocAction extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private PermissionService permissionService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    /**
     * 保存的doc值
     */
    private String docValue;
    /**
     * 传来的单个卷内Id
     */
    private String docId;
    /**
     * 当前是否为打印状态
     */
    private boolean isPrint;

    public boolean isPrint() {
        return isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public String getDocId() {
        return docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public String getDocValue() {
        return docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public String getPermJson() {
        List<Item> operations = dictService.getItems(Permission.OPERATION_DICT);
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    @Override
    public String execute() throws Exception {
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId() == null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Document> documents = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems();
                if (documents.size() > 0) {
                    documents.get(0).setArchive(archiveService.getArchive(modelName, archiveId));
                }
                return new Page<Document>(documents);
            } else {
                Page<Document> page = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL);
                List<Document> lists=page.getItems();
                for(Object object:lists){
                    try {
                        String id= PropertyUtils.getProperty(object, "id").toString();
                        PropertyUtils.setProperty(object,"hasOriginal",originalService.hasOriginal(id));
                    } catch (Exception e) {
                        break;
                    }
                }

                if(isPrint){
                    String printCount  = EnvHolder.getAppEnv().get(Switch.DOCUMENT_PRINT_COUNT);
                    if(printCount != null && StringUtils.isNotBlank(printCount)){
                        int iCount = Integer.parseInt(printCount);
                        int j = 0;
                        if(page.getItems().size() % iCount != 0)
                        {
                            j = iCount - (page.getItems().size() % 18);
                        }

                        for(int i = 0; i < j; i++){
                            Document document = entityService.newInstance(modelName);
                            document.setArchiveId(archiveId);
                            page.getItems().add(document);
                        }
                    }
                }

                return page;
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Document> page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank(document.getArchiveId())) {
                    document.setArchive(archiveService.getArchive(modelName, document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected Page<Document> searchDocentity(List<Criterion> criterions, List<Order> orders, String archiveId) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Document> documents = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems();
                if (documents.size() > 0) {
                    documents.get(0).setArchive(archiveService.getArchive(modelName, archiveId));
                }
                return new Page<Document>(documents);
            } else {
                return new Page<Document>(entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Document> page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank(document.getArchiveId())) {
                    document.setArchive(archiveService.getArchive(modelName, document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (type == null || !type.equals("all"))
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull("archiveId") : Restrictions.isNull("archiveId"));
        if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
            String[] name = modelName.split("_");
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(name[0]);
            List<String> mlhs = new ArrayList<String>();
            String roleids = SessionUtil.getCurrentUser().getRoleIds();
            if (roleids != null) {
                for (String roleid : roleids.split(",")) {
                    roleid = roleid.substring(1, roleid.length() - 1);
                    for (AjhRange ajhRange : ajhRanges) {
                        if (permissionService.getPermissions(ajhRange.getId(), roleid).size() != 0) {
                            mlhs.add(ajhRange.getMlh());
                        }
                    }
                }

                if (mlhs.size() > 0) {
                    String sSQL = "(";
                    for (String mlh : mlhs) {
                        sSQL = sSQL + "mlh = '" + mlh + "' OR ";
                    }
                    sSQL = sSQL.substring(0, sSQL.length() - 4);
                    sSQL = sSQL + ")";
                    criterions.add(Restrictions.sqlRestriction(sSQL));
                }
            }
        }
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if (superOrders.size() > 0) return superOrders;
        if (StringUtils.isNotEmpty(archiveId))
            orders.add(Order.desc("sxh"));
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     * 获取卷内所属的档案
     *
     * @return
     */
    private Map docArchive;

    public Map getDocArchive() {
        try {
            if (docArchive == null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(modelName, archiveId), SerializerFeature.WriteMapNullValue));
                docArchive.remove("id");
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    public void saveDoc() {
        try {
            if(docValue == null || StringUtils.isBlank(docValue)){
                return;
            }
            List docList = JSONArray.parseArray(docValue);
            if(docList != null && docList.size() > 0){
                for(int i = 0; i < docList.size(); i++) {
                    Map docMap = (Map) docList.get(i);
                    Document document = archiveService.getDocument(modelName, docMap.get("id").toString());
                    document.setSxh(Integer.parseInt(docMap.get("sxh").toString()));
                    document.setYh(docMap.get("yh").toString());
                    archiveService.saveDocument(document);
                }
            }
            renderJson(Action.SUCCESS);
        } catch(Exception ex) {
            renderJson(ex.getMessage());
        }
    }

    public void upDocument() throws Exception {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders = new ArrayList<Order>();
        Document temp = archiveService.getDocument(modelName, docId);
        Integer docSxh;
        docSxh = temp.getSxh();
        criterions.clear();
        criterions.add(Restrictions.and(Restrictions.eq("sxh", docSxh - 1), Restrictions.eq("archiveId", archiveId)));
        orders = new ArrayList<Order>();
        orders.add(Order.desc(sort));
        Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
        if (page.getPageCount() == 0) {
            return;
        }
        List<Document> documents = page.getItems();
        Document movDoc = documents.get(0);
        Integer movSxh = movDoc.getSxh();
        temp.setSxh(movSxh);
        movDoc.setSxh(docSxh);
        entityService.save(movDoc);
        entityService.save(temp);
    }

    public void downDocument() {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders = new ArrayList<Order>();
        Document temp = archiveService.getDocument(modelName, docId);
        Integer docSxh;
        docSxh = temp.getSxh();
        criterions.clear();
        criterions.add(Restrictions.and(Restrictions.eq("sxh", docSxh + 1), Restrictions.eq("archiveId", archiveId)));
        orders = new ArrayList<Order>();
        orders.add(Order.desc(sort));
        Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
        if (page.getPageCount() == 0) {
            return;
        }
        List<Document> documents = page.getItems();
        Document movDoc = documents.get(0);
        Integer movSxh = movDoc.getSxh();
        temp.setSxh(movSxh);
        movDoc.setSxh(docSxh);
        entityService.save(movDoc);
        entityService.save(temp);
    }

    public void saveSort() throws Exception {
        try {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("archiveId", archiveId));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc(sort));
            Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
            List<Document> documents = page.getItems();
            int start = 1;
            for (int i = 0; i < documents.size(); i++) {
                Document temp = documents.get(i);
                if (temp.getSxh().equals(i + 1)) {
                    String yhStr = temp.getYh();
                    String begin = yhStr.split("-")[0];
                    String end = yhStr.split("-")[1];
                    //需要移动案卷号长度
                    Integer len1 = Integer.valueOf(end) - Integer.valueOf(begin);
                    Integer newStart;
                    Integer newEnd;
                    if(temp.getSxh() == 1) {
                        newStart = start;
                        newEnd = newStart + len1;
                        start = newEnd;
                    }
                    else {
                        newStart = start + 1;
                        newEnd = newStart + len1;
                        start = newEnd;
                    }
                    String newYh = newStart+"-"+newEnd+"";
                    temp.setYh(newYh);
                    entityService.save(temp);
                }
            }
        }catch (Exception e){
            logger.error("保存排序出现异常"+e.toString());
        }
    }


    /**
     * 续添一条卷内
     */
    public void addOneDoc() {
        Document  entity = archiveService.newDocument(modelName);
        Archive archive = archiveService.getArchive(modelName,archiveId);
        Document document = archiveService.getMaxSxhDocuments(modelName,archiveId);
        if(document == null) {
            entity.setSxh(1);
        } else {
            entity.setSxh(document.getSxh()+1);
        }
        entity.setArchive(archive);
        entity.setAjh(archive.getAjh());
        entity.setMlh(archive.getMlh());
        entity.setQzh(archive.getQzh());
        entity.setArchiveId(archive.getId());
        entityService.save(entity);
        Map map = new HashMap();
        map.put("docId",entity.getId());
        map.put("sxh",entity.getSxh());
        map.put("ajh",entity.getAjh()==null?"":entity.getAjh());
        map.put("qzh",entity.getQzh()==null?"":entity.getQzh());
        map.put("mlh",entity.getMlh()==null?"":entity.getMlh());
        map.put("modelName",entity.getModelName());
        map.put("archiveId",entity.getArchiveId());
        renderJson(map);
        logger.info("新增一条卷内所属案卷的id为"+archiveId+",卷内的id为"+entity.getId());
    }

    /**
     * 保存所有续添的卷内
     */
    public void saveOrUpdateDocs() {
        if(StringUtils.isEmpty(docValue)) {
            return;
        } else {
            List<Document> docList = new ArrayList<Document>(JSONArray.parseArray(docValue,Document.class));
            for(Document doc : docList) {
                archiveService.saveDocument(doc);
            }
            renderJson(Action.SUCCESS);
        }
    }

    /**
     * 获取修改的卷内的信息
     */
    public void getDocInfo() {
        if(StringUtils.isEmpty(docId)) {
            return;
        } else {
            Document document = archiveService.getDocument(modelName,docId);
            Map map = new HashMap();
            map.put("docId",document.getId());
            map.put("ajh",document.getAjh()==null?"":document.getAjh());
            map.put("qzh",document.getQzh()==null?"":document.getQzh());
            map.put("mlh",document.getMlh()==null?"":document.getMlh());
            map.put("modelName",document.getModelName());
            map.put("archiveId",document.getArchiveId());
            renderJson(map);
            logger.info("获取id为"+docId+"的信息");
        }
    }
}
