package com.gtis.archive.util;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.environment.EnvHolder;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-29
 */
public class SearchUtils {
    private static String getValue(String s) {
        int i = s.indexOf(",");
        try {
            return i == -1 || i == s.length() - 1 ? null : URLDecoder.decode(s.substring(i + 1), Constants.DEFAULT_CHARSET);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static Criterion conditionToCriterion(Field field, String op, String value) {
        if ("eq".equals(op)) {
            return Restrictions.eq(field.getName(), field.getValue(value));
        } else if ("like".equals(op)) {
            if(EnvHolder.isEnable(Switch.SPLIT_QUERY)){
            String s = field.getName();
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("^[a-z]+$");
            java.util.regex.Matcher m = pattern.matcher(s);
            if (!m.matches()) {
                String[] ss = s.split("(?=[A-Z])");
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < ss.length - 1; i++) {
                    builder.append(ss[i]).append("_");
                }
                builder.append(ss[ss.length - 1]);
                return Restrictions.sqlRestriction("to_char(" + builder.toString() + ") like ?", "%" + value + "%", Hibernate.STRING);
            }
        }
            return Restrictions.sqlRestriction("to_char("+field.getName()+") like ?","%"+value+"%", Hibernate.STRING);
//           return Restrictions.like(field.getName(),"%"+value+"%");
        } else if ("ne".equals(op)) {
            return Restrictions.ne(field.getName(), field.getValue(value));
        } else if ("gt".equals(op)) {
            return Restrictions.gt(field.getName(), field.getValue(value));
        } else if ("lt".equals(op)) {
            return Restrictions.lt(field.getName(), field.getValue(value));
        } else if ("isNull".equals(op)) {
            return Restrictions.isNull(field.getName());
        } else if ("notNull".equals(op)) {
            return Restrictions.isNotNull(field.getName());
        }
        return null;
    }

    public static List<Criterion> conditionToCriterion(Map<String, Field> fieldMap, String condition) {
        List<Criterion> criterions = new ArrayList<Criterion>();
        String[] cs = condition.split(";");
        for (int i = 0; i < cs.length; i += 3) {
            String name = SearchUtils.getValue(cs[i]);
            String op = getValue(cs[i + 1]);
            String value = getValue(cs[i + 2]);
            if (name == null || value == null)
                continue;
            criterions.add(conditionToCriterion(fieldMap.get(name), op, value));
        }
        return criterions;
    }
}
